/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.method.annotation;

import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotatedElementUtils;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.bind.annotation.SessionAttributes;
import com.baidu.cloud.thirdparty.springframework.web.bind.support.SessionAttributeStore;
import com.baidu.cloud.thirdparty.springframework.web.context.request.WebRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionAttributesHandler {
    private final Set<String> attributeNames = new HashSet<String>();
    private final Set<Class<?>> attributeTypes = new HashSet();
    private final Set<String> knownAttributeNames = Collections.newSetFromMap(new ConcurrentHashMap(4));
    private final SessionAttributeStore sessionAttributeStore;

    public SessionAttributesHandler(Class<?> handlerType, SessionAttributeStore sessionAttributeStore) {
        Assert.notNull((Object)sessionAttributeStore, "SessionAttributeStore may not be null");
        this.sessionAttributeStore = sessionAttributeStore;
        SessionAttributes ann = AnnotatedElementUtils.findMergedAnnotation(handlerType, SessionAttributes.class);
        if (ann != null) {
            Collections.addAll(this.attributeNames, ann.names());
            Collections.addAll(this.attributeTypes, ann.types());
        }
        this.knownAttributeNames.addAll(this.attributeNames);
    }

    public boolean hasSessionAttributes() {
        return !this.attributeNames.isEmpty() || !this.attributeTypes.isEmpty();
    }

    public boolean isHandlerSessionAttribute(String attributeName, Class<?> attributeType) {
        Assert.notNull((Object)attributeName, "Attribute name must not be null");
        if (this.attributeNames.contains(attributeName) || this.attributeTypes.contains(attributeType)) {
            this.knownAttributeNames.add(attributeName);
            return true;
        }
        return false;
    }

    public void storeAttributes(WebRequest request, Map<String, ?> attributes) {
        attributes.forEach((name, value) -> {
            if (value != null && this.isHandlerSessionAttribute((String)name, value.getClass())) {
                this.sessionAttributeStore.storeAttribute(request, (String)name, value);
            }
        });
    }

    public Map<String, Object> retrieveAttributes(WebRequest request) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (String name : this.knownAttributeNames) {
            Object value = this.sessionAttributeStore.retrieveAttribute(request, name);
            if (value == null) continue;
            attributes.put(name, value);
        }
        return attributes;
    }

    public void cleanupAttributes(WebRequest request) {
        for (String attributeName : this.knownAttributeNames) {
            this.sessionAttributeStore.cleanupAttribute(request, attributeName);
        }
    }

    @Nullable
    Object retrieveAttribute(WebRequest request, String attributeName) {
        return this.sessionAttributeStore.retrieveAttribute(request, attributeName);
    }
}

