/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.multipart.support;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequestWrapper;
import com.baidu.cloud.thirdparty.springframework.http.HttpHeaders;
import com.baidu.cloud.thirdparty.springframework.http.HttpMethod;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.LinkedMultiValueMap;
import com.baidu.cloud.thirdparty.springframework.util.MultiValueMap;
import com.baidu.cloud.thirdparty.springframework.web.multipart.MultipartFile;
import com.baidu.cloud.thirdparty.springframework.web.multipart.MultipartHttpServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractMultipartHttpServletRequest
extends HttpServletRequestWrapper
implements MultipartHttpServletRequest {
    @Nullable
    private MultiValueMap<String, MultipartFile> multipartFiles;

    protected AbstractMultipartHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    @Override
    public HttpServletRequest getRequest() {
        return (HttpServletRequest)super.getRequest();
    }

    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.resolve(this.getRequest().getMethod());
    }

    @Override
    public HttpHeaders getRequestHeaders() {
        HttpHeaders headers = new HttpHeaders();
        Enumeration<String> headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            headers.put(headerName, (List<String>)Collections.list(this.getHeaders(headerName)));
        }
        return headers;
    }

    @Override
    public Iterator<String> getFileNames() {
        return this.getMultipartFiles().keySet().iterator();
    }

    @Override
    public MultipartFile getFile(String name) {
        return this.getMultipartFiles().getFirst(name);
    }

    @Override
    public List<MultipartFile> getFiles(String name) {
        List multipartFiles = (List)this.getMultipartFiles().get(name);
        if (multipartFiles != null) {
            return multipartFiles;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, MultipartFile> getFileMap() {
        return this.getMultipartFiles().toSingleValueMap();
    }

    @Override
    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        return this.getMultipartFiles();
    }

    public boolean isResolved() {
        return this.multipartFiles != null;
    }

    protected final void setMultipartFiles(MultiValueMap<String, MultipartFile> multipartFiles) {
        this.multipartFiles = new LinkedMultiValueMap<String, MultipartFile>(Collections.unmodifiableMap(multipartFiles));
    }

    protected MultiValueMap<String, MultipartFile> getMultipartFiles() {
        if (this.multipartFiles == null) {
            this.initializeMultipart();
        }
        return this.multipartFiles;
    }

    protected void initializeMultipart() {
        throw new IllegalStateException("Multipart request not initialized");
    }
}

