/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.multipart.support;

import com.baidu.cloud.thirdparty.servlet.FilterChain;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.web.context.WebApplicationContext;
import com.baidu.cloud.thirdparty.springframework.web.context.support.WebApplicationContextUtils;
import com.baidu.cloud.thirdparty.springframework.web.filter.OncePerRequestFilter;
import com.baidu.cloud.thirdparty.springframework.web.multipart.MultipartHttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.web.multipart.MultipartResolver;
import com.baidu.cloud.thirdparty.springframework.web.multipart.support.StandardServletMultipartResolver;
import java.io.IOException;

public class MultipartFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_MULTIPART_RESOLVER_BEAN_NAME = "filterMultipartResolver";
    private final MultipartResolver defaultMultipartResolver = new StandardServletMultipartResolver();
    private String multipartResolverBeanName = "filterMultipartResolver";

    public void setMultipartResolverBeanName(String multipartResolverBeanName) {
        this.multipartResolverBeanName = multipartResolverBeanName;
    }

    protected String getMultipartResolverBeanName() {
        return this.multipartResolverBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest processedRequest;
        MultipartResolver multipartResolver = this.lookupMultipartResolver(request);
        if (multipartResolver.isMultipart(processedRequest = request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Resolving multipart request [" + processedRequest.getRequestURI() + "] with MultipartFilter");
            }
            processedRequest = multipartResolver.resolveMultipart(processedRequest);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Request [" + processedRequest.getRequestURI() + "] is not a multipart request");
        }
        try {
            filterChain.doFilter(processedRequest, response);
        }
        finally {
            if (processedRequest instanceof MultipartHttpServletRequest) {
                multipartResolver.cleanupMultipart((MultipartHttpServletRequest)processedRequest);
            }
        }
    }

    protected MultipartResolver lookupMultipartResolver(HttpServletRequest request) {
        return this.lookupMultipartResolver();
    }

    protected MultipartResolver lookupMultipartResolver() {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(this.getServletContext());
        String beanName = this.getMultipartResolverBeanName();
        if (wac != null && wac.containsBean(beanName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using MultipartResolver '" + beanName + "' for MultipartFilter");
            }
            return wac.getBean(beanName, MultipartResolver.class);
        }
        return this.defaultMultipartResolver;
    }
}

