/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.servlet.ServletConfig;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.http.HttpServlet;
import com.baidu.cloud.thirdparty.springframework.beans.BeanWrapper;
import com.baidu.cloud.thirdparty.springframework.beans.BeansException;
import com.baidu.cloud.thirdparty.springframework.beans.MutablePropertyValues;
import com.baidu.cloud.thirdparty.springframework.beans.PropertyAccessorFactory;
import com.baidu.cloud.thirdparty.springframework.beans.PropertyValue;
import com.baidu.cloud.thirdparty.springframework.context.EnvironmentAware;
import com.baidu.cloud.thirdparty.springframework.core.env.ConfigurableEnvironment;
import com.baidu.cloud.thirdparty.springframework.core.env.Environment;
import com.baidu.cloud.thirdparty.springframework.core.env.EnvironmentCapable;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.core.io.ResourceEditor;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.context.support.ServletContextResourceLoader;
import com.baidu.cloud.thirdparty.springframework.web.context.support.StandardServletEnvironment;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public abstract class HttpServletBean
extends HttpServlet
implements EnvironmentCapable,
EnvironmentAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private ConfigurableEnvironment environment;
    private final Set<String> requiredProperties = new HashSet<String>(4);

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    @Override
    public void setEnvironment(Environment environment2) {
        Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment2, "ConfigurableEnvironment required");
        this.environment = (ConfigurableEnvironment)environment2;
    }

    @Override
    public ConfigurableEnvironment getEnvironment() {
        if (this.environment == null) {
            this.environment = this.createEnvironment();
        }
        return this.environment;
    }

    protected ConfigurableEnvironment createEnvironment() {
        return new StandardServletEnvironment();
    }

    @Override
    public final void init() throws ServletException {
        ServletConfigPropertyValues pvs;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Initializing servlet '" + this.getServletName() + "'");
        }
        if (!(pvs = new ServletConfigPropertyValues(this.getServletConfig(), this.requiredProperties)).isEmpty()) {
            try {
                BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(this);
                ServletContextResourceLoader resourceLoader = new ServletContextResourceLoader(this.getServletContext());
                bw.registerCustomEditor(Resource.class, new ResourceEditor(resourceLoader, this.getEnvironment()));
                this.initBeanWrapper(bw);
                bw.setPropertyValues(pvs, true);
            }
            catch (BeansException ex) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Failed to set bean properties on servlet '" + this.getServletName() + "'", ex);
                }
                throw ex;
            }
        }
        this.initServletBean();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Servlet '" + this.getServletName() + "' configured successfully");
        }
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
    }

    protected void initServletBean() throws ServletException {
    }

    @Override
    @Nullable
    public String getServletName() {
        return this.getServletConfig() != null ? this.getServletConfig().getServletName() : null;
    }

    private static class ServletConfigPropertyValues
    extends MutablePropertyValues {
        public ServletConfigPropertyValues(ServletConfig config, Set<String> requiredProperties) throws ServletException {
            HashSet<String> missingProps = !CollectionUtils.isEmpty(requiredProperties) ? new HashSet<String>(requiredProperties) : null;
            Enumeration<String> paramNames = config.getInitParameterNames();
            while (paramNames.hasMoreElements()) {
                String property = paramNames.nextElement();
                String value = config.getInitParameter(property);
                this.addPropertyValue(new PropertyValue(property, (Object)value));
                if (missingProps == null) continue;
                missingProps.remove(property);
            }
            if (!CollectionUtils.isEmpty(missingProps)) {
                throw new ServletException("Initialization from ServletConfig for servlet '" + config.getServletName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(missingProps, ", "));
            }
        }
    }
}

