/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation;

import com.baidu.cloud.thirdparty.springframework.cache.Cache;
import com.baidu.cloud.thirdparty.springframework.cache.concurrent.ConcurrentMapCache;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.CachingResourceResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.CachingResourceTransformer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.CssLinkResourceTransformer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.PathResourceResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceTransformer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.VersionResourceResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.WebJarsResourceResolver;
import java.util.ArrayList;
import java.util.List;

public class ResourceChainRegistration {
    private static final String DEFAULT_CACHE_NAME = "spring-resource-chain-cache";
    private static final boolean isWebJarsAssetLocatorPresent = ClassUtils.isPresent("org.webjars.WebJarAssetLocator", ResourceChainRegistration.class.getClassLoader());
    private final List<ResourceResolver> resolvers = new ArrayList<ResourceResolver>(4);
    private final List<ResourceTransformer> transformers = new ArrayList<ResourceTransformer>(4);
    private boolean hasVersionResolver;
    private boolean hasPathResolver;
    private boolean hasCssLinkTransformer;
    private boolean hasWebjarsResolver;

    public ResourceChainRegistration(boolean cacheResources) {
        this(cacheResources, cacheResources ? new ConcurrentMapCache(DEFAULT_CACHE_NAME) : null);
    }

    public ResourceChainRegistration(boolean cacheResources, @Nullable Cache cache) {
        Assert.isTrue(!cacheResources || cache != null, "'cache' is required when cacheResources=true");
        if (cacheResources) {
            this.resolvers.add(new CachingResourceResolver(cache));
            this.transformers.add(new CachingResourceTransformer(cache));
        }
    }

    public ResourceChainRegistration addResolver(ResourceResolver resolver) {
        Assert.notNull((Object)resolver, "The provided ResourceResolver should not be null");
        this.resolvers.add(resolver);
        if (resolver instanceof VersionResourceResolver) {
            this.hasVersionResolver = true;
        } else if (resolver instanceof PathResourceResolver) {
            this.hasPathResolver = true;
        } else if (resolver instanceof WebJarsResourceResolver) {
            this.hasWebjarsResolver = true;
        }
        return this;
    }

    public ResourceChainRegistration addTransformer(ResourceTransformer transformer) {
        Assert.notNull((Object)transformer, "The provided ResourceTransformer should not be null");
        this.transformers.add(transformer);
        if (transformer instanceof CssLinkResourceTransformer) {
            this.hasCssLinkTransformer = true;
        }
        return this;
    }

    protected List<ResourceResolver> getResourceResolvers() {
        if (!this.hasPathResolver) {
            ArrayList<ResourceResolver> result = new ArrayList<ResourceResolver>(this.resolvers);
            if (isWebJarsAssetLocatorPresent && !this.hasWebjarsResolver) {
                result.add(new WebJarsResourceResolver());
            }
            result.add(new PathResourceResolver());
            return result;
        }
        return this.resolvers;
    }

    protected List<ResourceTransformer> getResourceTransformers() {
        if (this.hasVersionResolver && !this.hasCssLinkTransformer) {
            ArrayList<ResourceTransformer> result = new ArrayList<ResourceTransformer>(this.transformers);
            boolean hasTransformers = !this.transformers.isEmpty();
            boolean hasCaching = hasTransformers && this.transformers.get(0) instanceof CachingResourceTransformer;
            result.add(hasCaching ? 1 : 0, new CssLinkResourceTransformer());
            return result;
        }
        return this.transformers;
    }
}

