/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.handler;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequestWrapper;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanFactoryUtils;
import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationContext;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationContextAware;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAwareOrderComparator;
import com.baidu.cloud.thirdparty.springframework.core.io.ClassPathResource;
import com.baidu.cloud.thirdparty.springframework.core.io.support.PropertiesLoaderUtils;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.cors.CorsConfiguration;
import com.baidu.cloud.thirdparty.springframework.web.cors.CorsConfigurationSource;
import com.baidu.cloud.thirdparty.springframework.web.servlet.DispatcherServlet;
import com.baidu.cloud.thirdparty.springframework.web.servlet.HandlerExecutionChain;
import com.baidu.cloud.thirdparty.springframework.web.servlet.HandlerInterceptor;
import com.baidu.cloud.thirdparty.springframework.web.servlet.HandlerMapping;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.MatchableHandlerMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class HandlerMappingIntrospector
implements CorsConfigurationSource,
ApplicationContextAware,
InitializingBean {
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private List<HandlerMapping> handlerMappings;

    public HandlerMappingIntrospector() {
    }

    @Deprecated
    public HandlerMappingIntrospector(ApplicationContext context) {
        this.handlerMappings = HandlerMappingIntrospector.initHandlerMappings(context);
    }

    public List<HandlerMapping> getHandlerMappings() {
        return this.handlerMappings != null ? this.handlerMappings : Collections.emptyList();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.handlerMappings == null) {
            Assert.notNull((Object)this.applicationContext, "No ApplicationContext");
            this.handlerMappings = HandlerMappingIntrospector.initHandlerMappings(this.applicationContext);
        }
    }

    @Nullable
    public MatchableHandlerMapping getMatchableHandlerMapping(HttpServletRequest request) throws Exception {
        Assert.notNull(this.handlerMappings, "Handler mappings not initialized");
        RequestAttributeChangeIgnoringWrapper wrapper = new RequestAttributeChangeIgnoringWrapper(request);
        for (HandlerMapping handlerMapping : this.handlerMappings) {
            HandlerExecutionChain handler = handlerMapping.getHandler(wrapper);
            if (handler == null) continue;
            if (handlerMapping instanceof MatchableHandlerMapping) {
                return (MatchableHandlerMapping)handlerMapping;
            }
            throw new IllegalStateException("HandlerMapping is not a MatchableHandlerMapping");
        }
        return null;
    }

    @Override
    @Nullable
    public CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
        Assert.notNull(this.handlerMappings, "Handler mappings not initialized");
        RequestAttributeChangeIgnoringWrapper wrapper = new RequestAttributeChangeIgnoringWrapper(request);
        for (HandlerMapping handlerMapping : this.handlerMappings) {
            HandlerExecutionChain handler = null;
            try {
                handler = handlerMapping.getHandler(wrapper);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (handler == null) continue;
            if (handler.getInterceptors() != null) {
                for (HandlerInterceptor interceptor : handler.getInterceptors()) {
                    if (!(interceptor instanceof CorsConfigurationSource)) continue;
                    return ((CorsConfigurationSource)((Object)interceptor)).getCorsConfiguration(wrapper);
                }
            }
            if (!(handler.getHandler() instanceof CorsConfigurationSource)) continue;
            return ((CorsConfigurationSource)handler.getHandler()).getCorsConfiguration(wrapper);
        }
        return null;
    }

    private static List<HandlerMapping> initHandlerMappings(ApplicationContext applicationContext) {
        Map<String, HandlerMapping> beans2 = BeanFactoryUtils.beansOfTypeIncludingAncestors(applicationContext, HandlerMapping.class, true, false);
        if (!beans2.isEmpty()) {
            ArrayList<HandlerMapping> mappings = new ArrayList<HandlerMapping>(beans2.values());
            AnnotationAwareOrderComparator.sort(mappings);
            return Collections.unmodifiableList(mappings);
        }
        return Collections.unmodifiableList(HandlerMappingIntrospector.initFallback(applicationContext));
    }

    private static List<HandlerMapping> initFallback(ApplicationContext applicationContext) {
        Properties props;
        String path = "DispatcherServlet.properties";
        try {
            ClassPathResource resource = new ClassPathResource(path, DispatcherServlet.class);
            props = PropertiesLoaderUtils.loadProperties(resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load '" + path + "': " + ex.getMessage());
        }
        String value = props.getProperty(HandlerMapping.class.getName());
        String[] names = StringUtils.commaDelimitedListToStringArray(value);
        ArrayList<HandlerMapping> result = new ArrayList<HandlerMapping>(names.length);
        for (String name : names) {
            try {
                Class<?> clazz = ClassUtils.forName(name, DispatcherServlet.class.getClassLoader());
                Object mapping = applicationContext.getAutowireCapableBeanFactory().createBean(clazz);
                result.add((HandlerMapping)mapping);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Could not find default HandlerMapping [" + name + "]");
            }
        }
        return result;
    }

    private static class RequestAttributeChangeIgnoringWrapper
    extends HttpServletRequestWrapper {
        public RequestAttributeChangeIgnoringWrapper(HttpServletRequest request) {
            super(request);
        }

        @Override
        public void setAttribute(String name, Object value) {
        }
    }
}

