/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.handler;

import com.baidu.cloud.thirdparty.servlet.Servlet;
import com.baidu.cloud.thirdparty.servlet.ServletConfig;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.springframework.beans.BeansException;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanInitializationException;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.web.context.ServletConfigAware;
import com.baidu.cloud.thirdparty.springframework.web.context.ServletContextAware;
import java.util.Collections;
import java.util.Enumeration;

public class SimpleServletPostProcessor
implements DestructionAwareBeanPostProcessor,
ServletContextAware,
ServletConfigAware {
    private boolean useSharedServletConfig = true;
    @Nullable
    private ServletContext servletContext;
    @Nullable
    private ServletConfig servletConfig;

    public void setUseSharedServletConfig(boolean useSharedServletConfig) {
        this.useSharedServletConfig = useSharedServletConfig;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof Servlet) {
            ServletConfig config = this.servletConfig;
            if (config == null || !this.useSharedServletConfig) {
                config = new DelegatingServletConfig(beanName, this.servletContext);
            }
            try {
                ((Servlet)bean2).init(config);
            }
            catch (ServletException ex) {
                throw new BeanInitializationException("Servlet.init threw exception", ex);
            }
        }
        return bean2;
    }

    @Override
    public void postProcessBeforeDestruction(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof Servlet) {
            ((Servlet)bean2).destroy();
        }
    }

    @Override
    public boolean requiresDestruction(Object bean2) {
        return bean2 instanceof Servlet;
    }

    private static class DelegatingServletConfig
    implements ServletConfig {
        private final String servletName;
        @Nullable
        private final ServletContext servletContext;

        public DelegatingServletConfig(String servletName, @Nullable ServletContext servletContext) {
            this.servletName = servletName;
            this.servletContext = servletContext;
        }

        @Override
        public String getServletName() {
            return this.servletName;
        }

        @Override
        @Nullable
        public ServletContext getServletContext() {
            return this.servletContext;
        }

        @Override
        @Nullable
        public String getInitParameter(String paramName) {
            return null;
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(Collections.emptySet());
        }
    }
}

