/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.handler;

import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import java.io.IOException;

public class UserRoleAuthorizationInterceptor
extends HandlerInterceptorAdapter {
    @Nullable
    private String[] authorizedRoles;

    public final void setAuthorizedRoles(String ... authorizedRoles) {
        this.authorizedRoles = authorizedRoles;
    }

    @Override
    public final boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException, IOException {
        if (this.authorizedRoles != null) {
            for (String role : this.authorizedRoles) {
                if (!request.isUserInRole(role)) continue;
                return true;
            }
        }
        this.handleNotAuthorized(request, response, handler);
        return false;
    }

    protected void handleNotAuthorized(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException, IOException {
        response.sendError(403);
    }
}

