/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.i18n;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.ObjectUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.LocaleResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import com.baidu.cloud.thirdparty.springframework.web.servlet.support.RequestContextUtils;
import java.util.Locale;

public class LocaleChangeInterceptor
extends HandlerInterceptorAdapter {
    public static final String DEFAULT_PARAM_NAME = "locale";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String paramName = "locale";
    @Nullable
    private String[] httpMethods;
    private boolean ignoreInvalidLocale = false;
    private boolean languageTagCompliant = false;

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setHttpMethods(String ... httpMethods) {
        this.httpMethods = httpMethods;
    }

    @Nullable
    public String[] getHttpMethods() {
        return this.httpMethods;
    }

    public void setIgnoreInvalidLocale(boolean ignoreInvalidLocale) {
        this.ignoreInvalidLocale = ignoreInvalidLocale;
    }

    public boolean isIgnoreInvalidLocale() {
        return this.ignoreInvalidLocale;
    }

    public void setLanguageTagCompliant(boolean languageTagCompliant) {
        this.languageTagCompliant = languageTagCompliant;
    }

    public boolean isLanguageTagCompliant() {
        return this.languageTagCompliant;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        String newLocale = request.getParameter(this.getParamName());
        if (newLocale != null && this.checkHttpMethod(request.getMethod())) {
            LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(request);
            if (localeResolver == null) {
                throw new IllegalStateException("No LocaleResolver found: not in a DispatcherServlet request?");
            }
            try {
                localeResolver.setLocale(request, response, this.parseLocaleValue(newLocale));
            }
            catch (IllegalArgumentException ex) {
                if (this.isIgnoreInvalidLocale()) {
                    this.logger.debug("Ignoring invalid locale value [" + newLocale + "]: " + ex.getMessage());
                }
                throw ex;
            }
        }
        return true;
    }

    private boolean checkHttpMethod(String currentMethod) {
        Object[] configuredMethods = this.getHttpMethods();
        if (ObjectUtils.isEmpty(configuredMethods)) {
            return true;
        }
        for (Object configuredMethod : configuredMethods) {
            if (!((String)configuredMethod).equalsIgnoreCase(currentMethod)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected Locale parseLocaleValue(String locale) {
        return this.isLanguageTagCompliant() ? Locale.forLanguageTag(locale) : StringUtils.parseLocaleString(locale);
    }
}

