/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.servlet.http.HttpSession;
import com.baidu.cloud.thirdparty.springframework.http.HttpMethod;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.web.servlet.ModelAndView;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.Controller;
import com.baidu.cloud.thirdparty.springframework.web.servlet.support.WebContentGenerator;
import com.baidu.cloud.thirdparty.springframework.web.util.WebUtils;

public abstract class AbstractController
extends WebContentGenerator
implements Controller {
    private boolean synchronizeOnSession = false;

    public AbstractController() {
        this(true);
    }

    public AbstractController(boolean restrictDefaultSupportedMethods) {
        super(restrictDefaultSupportedMethods);
    }

    public final void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public final boolean isSynchronizeOnSession() {
        return this.synchronizeOnSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session;
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            response.setHeader("Allow", this.getAllowHeader());
            return null;
        }
        this.checkRequest(request);
        this.prepareResponse(response);
        if (this.synchronizeOnSession && (session = request.getSession(false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex(session);
            synchronized (object) {
                return this.handleRequestInternal(request, response);
            }
        }
        return this.handleRequestInternal(request, response);
    }

    @Nullable
    protected abstract ModelAndView handleRequestInternal(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
}

