/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.annotation;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.context.MessageSource;
import com.baidu.cloud.thirdparty.springframework.context.MessageSourceAware;
import com.baidu.cloud.thirdparty.springframework.context.i18n.LocaleContextHolder;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotatedElementUtils;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.bind.annotation.ResponseStatus;
import com.baidu.cloud.thirdparty.springframework.web.server.ResponseStatusException;
import com.baidu.cloud.thirdparty.springframework.web.servlet.ModelAndView;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import java.io.IOException;

public class ResponseStatusExceptionResolver
extends AbstractHandlerExceptionResolver
implements MessageSourceAware {
    @Nullable
    private MessageSource messageSource;

    @Override
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    @Nullable
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception ex) {
        block5: {
            try {
                if (ex instanceof ResponseStatusException) {
                    return this.resolveResponseStatusException((ResponseStatusException)ex, request, response, handler);
                }
                ResponseStatus status = AnnotatedElementUtils.findMergedAnnotation(ex.getClass(), ResponseStatus.class);
                if (status != null) {
                    return this.resolveResponseStatus(status, request, response, handler, ex);
                }
                if (ex.getCause() instanceof Exception) {
                    return this.doResolveException(request, response, handler, (Exception)ex.getCause());
                }
            }
            catch (Exception resolveEx) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn("Failure while trying to resolve exception [" + ex.getClass().getName() + "]", resolveEx);
            }
        }
        return null;
    }

    protected ModelAndView resolveResponseStatus(ResponseStatus responseStatus, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception ex) throws Exception {
        int statusCode = responseStatus.code().value();
        String reason = responseStatus.reason();
        return this.applyStatusAndReason(statusCode, reason, response);
    }

    protected ModelAndView resolveResponseStatusException(ResponseStatusException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws Exception {
        int statusCode = ex.getStatus().value();
        String reason = ex.getReason();
        return this.applyStatusAndReason(statusCode, reason, response);
    }

    protected ModelAndView applyStatusAndReason(int statusCode, @Nullable String reason, HttpServletResponse response) throws IOException {
        if (!StringUtils.hasLength(reason)) {
            response.sendError(statusCode);
        } else {
            String resolvedReason = this.messageSource != null ? this.messageSource.getMessage(reason, null, reason, LocaleContextHolder.getLocale()) : reason;
            response.sendError(statusCode, resolvedReason);
        }
        return new ModelAndView();
    }
}

