/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ObjectUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.AbstractRequestCondition;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.RequestCondition;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.RequestConditionHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CompositeRequestCondition
extends AbstractRequestCondition<CompositeRequestCondition> {
    private final RequestConditionHolder[] requestConditions;

    public CompositeRequestCondition(RequestCondition<?> ... requestConditions) {
        this.requestConditions = this.wrap(requestConditions);
    }

    private CompositeRequestCondition(RequestConditionHolder[] requestConditions) {
        this.requestConditions = requestConditions;
    }

    private RequestConditionHolder[] wrap(RequestCondition<?> ... rawConditions) {
        RequestConditionHolder[] wrappedConditions = new RequestConditionHolder[rawConditions.length];
        for (int i = 0; i < rawConditions.length; ++i) {
            wrappedConditions[i] = new RequestConditionHolder(rawConditions[i]);
        }
        return wrappedConditions;
    }

    @Override
    public boolean isEmpty() {
        return ObjectUtils.isEmpty(this.requestConditions);
    }

    public List<RequestCondition<?>> getConditions() {
        return this.unwrap();
    }

    private List<RequestCondition<?>> unwrap() {
        ArrayList result = new ArrayList();
        for (RequestConditionHolder holder : this.requestConditions) {
            result.add(holder.getCondition());
        }
        return result;
    }

    @Override
    protected Collection<?> getContent() {
        return !this.isEmpty() ? this.getConditions() : Collections.emptyList();
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    private int getLength() {
        return this.requestConditions.length;
    }

    @Override
    public CompositeRequestCondition combine(CompositeRequestCondition other) {
        if (this.isEmpty() && other.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        this.assertNumberOfConditions(other);
        RequestConditionHolder[] combinedConditions = new RequestConditionHolder[this.getLength()];
        for (int i = 0; i < this.getLength(); ++i) {
            combinedConditions[i] = this.requestConditions[i].combine(other.requestConditions[i]);
        }
        return new CompositeRequestCondition(combinedConditions);
    }

    private void assertNumberOfConditions(CompositeRequestCondition other) {
        Assert.isTrue(this.getLength() == other.getLength(), "Cannot combine CompositeRequestConditions with a different number of conditions. " + ObjectUtils.nullSafeToString(this.requestConditions) + " and  " + ObjectUtils.nullSafeToString(other.requestConditions));
    }

    @Override
    @Nullable
    public CompositeRequestCondition getMatchingCondition(HttpServletRequest request) {
        if (this.isEmpty()) {
            return this;
        }
        RequestConditionHolder[] matchingConditions = new RequestConditionHolder[this.getLength()];
        for (int i = 0; i < this.getLength(); ++i) {
            matchingConditions[i] = this.requestConditions[i].getMatchingCondition(request);
            if (matchingConditions[i] != null) continue;
            return null;
        }
        return new CompositeRequestCondition(matchingConditions);
    }

    @Override
    public int compareTo(CompositeRequestCondition other, HttpServletRequest request) {
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return 1;
        }
        if (other.isEmpty()) {
            return -1;
        }
        this.assertNumberOfConditions(other);
        for (int i = 0; i < this.getLength(); ++i) {
            int result = this.requestConditions[i].compareTo(other.requestConditions[i], request);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

