/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.http.InvalidMediaTypeException;
import com.baidu.cloud.thirdparty.springframework.http.MediaType;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.cors.CorsUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.AbstractMediaTypeExpression;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.AbstractRequestCondition;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.MediaTypeExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ConsumesRequestCondition
extends AbstractRequestCondition<ConsumesRequestCondition> {
    private static final ConsumesRequestCondition PRE_FLIGHT_MATCH = new ConsumesRequestCondition(new String[0]);
    private final List<ConsumeMediaTypeExpression> expressions;

    public ConsumesRequestCondition(String ... consumes) {
        this(consumes, (String[])null);
    }

    public ConsumesRequestCondition(String[] consumes, @Nullable String[] headers) {
        this(ConsumesRequestCondition.parseExpressions(consumes, headers));
    }

    private ConsumesRequestCondition(Collection<ConsumeMediaTypeExpression> expressions) {
        this.expressions = new ArrayList<ConsumeMediaTypeExpression>(expressions);
        Collections.sort(this.expressions);
    }

    private static Set<ConsumeMediaTypeExpression> parseExpressions(String[] consumes, @Nullable String[] headers) {
        LinkedHashSet<ConsumeMediaTypeExpression> result = new LinkedHashSet<ConsumeMediaTypeExpression>();
        if (headers != null) {
            for (String header : headers) {
                HeadersRequestCondition.HeaderExpression expr = new HeadersRequestCondition.HeaderExpression(header);
                if (!"Content-Type".equalsIgnoreCase(expr.name) || expr.value == null) continue;
                for (MediaType mediaType : MediaType.parseMediaTypes((String)expr.value)) {
                    result.add(new ConsumeMediaTypeExpression(mediaType, expr.isNegated));
                }
            }
        }
        for (String consume : consumes) {
            result.add(new ConsumeMediaTypeExpression(consume));
        }
        return result;
    }

    public Set<MediaTypeExpression> getExpressions() {
        return new LinkedHashSet<MediaTypeExpression>(this.expressions);
    }

    public Set<MediaType> getConsumableMediaTypes() {
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        for (ConsumeMediaTypeExpression expression : this.expressions) {
            if (expression.isNegated()) continue;
            result.add(expression.getMediaType());
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    @Override
    protected Collection<ConsumeMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public ConsumesRequestCondition combine(ConsumesRequestCondition other) {
        return !other.expressions.isEmpty() ? other : this;
    }

    @Override
    @Nullable
    public ConsumesRequestCondition getMatchingCondition(HttpServletRequest request) {
        MediaType contentType;
        if (CorsUtils.isPreFlightRequest(request)) {
            return PRE_FLIGHT_MATCH;
        }
        if (this.isEmpty()) {
            return this;
        }
        try {
            contentType = StringUtils.hasLength(request.getContentType()) ? MediaType.parseMediaType(request.getContentType()) : MediaType.APPLICATION_OCTET_STREAM;
        }
        catch (InvalidMediaTypeException ex) {
            return null;
        }
        LinkedHashSet<ConsumeMediaTypeExpression> result = new LinkedHashSet<ConsumeMediaTypeExpression>(this.expressions);
        result.removeIf(expression -> !expression.match(contentType));
        return !result.isEmpty() ? new ConsumesRequestCondition(result) : null;
    }

    @Override
    public int compareTo(ConsumesRequestCondition other, HttpServletRequest request) {
        if (this.expressions.isEmpty() && other.expressions.isEmpty()) {
            return 0;
        }
        if (this.expressions.isEmpty()) {
            return 1;
        }
        if (other.expressions.isEmpty()) {
            return -1;
        }
        return this.expressions.get(0).compareTo(other.expressions.get(0));
    }

    static class ConsumeMediaTypeExpression
    extends AbstractMediaTypeExpression {
        ConsumeMediaTypeExpression(String expression) {
            super(expression);
        }

        ConsumeMediaTypeExpression(MediaType mediaType, boolean negated) {
            super(mediaType, negated);
        }

        public final boolean match(MediaType contentType) {
            boolean match = this.getMediaType().includes(contentType);
            return !this.isNegated() ? match : !match;
        }
    }
}

