/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation;

import com.baidu.cloud.thirdparty.springframework.core.MethodParameter;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.ui.ExtendedModelMap;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.context.request.NativeWebRequest;
import com.baidu.cloud.thirdparty.springframework.web.method.annotation.ModelAttributeMethodProcessor;
import com.baidu.cloud.thirdparty.springframework.web.method.support.HandlerMethodReturnValueHandler;
import com.baidu.cloud.thirdparty.springframework.web.method.support.ModelAndViewContainer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.ModelAndView;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.annotation.ModelAndViewResolver;
import java.lang.reflect.Method;
import java.util.List;

public class ModelAndViewResolverMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    @Nullable
    private final List<ModelAndViewResolver> mavResolvers;
    private final ModelAttributeMethodProcessor modelAttributeProcessor = new ModelAttributeMethodProcessor(true);

    public ModelAndViewResolverMethodReturnValueHandler(@Nullable List<ModelAndViewResolver> mavResolvers) {
        this.mavResolvers = mavResolvers;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return true;
    }

    @Override
    public void handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (this.mavResolvers != null) {
            for (ModelAndViewResolver mavResolver : this.mavResolvers) {
                Class<?> handlerType = returnType.getContainingClass();
                Method method = returnType.getMethod();
                Assert.state(method != null, "No handler method");
                ExtendedModelMap model = (ExtendedModelMap)mavContainer.getModel();
                ModelAndView mav = mavResolver.resolveModelAndView(method, handlerType, returnValue, model, webRequest);
                if (mav == ModelAndViewResolver.UNRESOLVED) continue;
                mavContainer.addAllAttributes(mav.getModel());
                mavContainer.setViewName(mav.getViewName());
                if (!mav.isReference()) {
                    mavContainer.setView(mav.getView());
                }
                return;
            }
        }
        if (!this.modelAttributeProcessor.supportsReturnType(returnType)) {
            throw new UnsupportedOperationException("Unexpected return type: " + returnType.getParameterType().getName() + " in method: " + returnType.getMethod());
        }
        this.modelAttributeProcessor.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
    }
}

