/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.resource;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceResolverChain;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceTransformer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceTransformerChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class DefaultResourceTransformerChain
implements ResourceTransformerChain {
    private final ResourceResolverChain resolverChain;
    private final List<ResourceTransformer> transformers = new ArrayList<ResourceTransformer>();
    private int index = -1;

    public DefaultResourceTransformerChain(ResourceResolverChain resolverChain, @Nullable List<ResourceTransformer> transformers) {
        Assert.notNull((Object)resolverChain, "ResourceResolverChain is required");
        this.resolverChain = resolverChain;
        if (transformers != null) {
            this.transformers.addAll(transformers);
        }
    }

    @Override
    public ResourceResolverChain getResolverChain() {
        return this.resolverChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource transform(HttpServletRequest request, Resource resource) throws IOException {
        ResourceTransformer transformer = this.getNext();
        if (transformer == null) {
            return resource;
        }
        try {
            Resource resource2 = transformer.transform(request, resource, this);
            return resource2;
        }
        finally {
            --this.index;
        }
    }

    @Nullable
    private ResourceTransformer getNext() {
        Assert.state(this.index <= this.transformers.size(), "Current index exceeds the number of configured ResourceTransformers");
        if (this.index == this.transformers.size() - 1) {
            return null;
        }
        ++this.index;
        return this.transformers.get(this.index);
    }
}

