/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.resource;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.servlet.FilterChain;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.ServletRequest;
import com.baidu.cloud.thirdparty.servlet.ServletResponse;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequestWrapper;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponseWrapper;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.web.filter.GenericFilterBean;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceUrlProvider;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceUrlProviderExposingInterceptor;
import com.baidu.cloud.thirdparty.springframework.web.util.UrlPathHelper;
import java.io.IOException;

public class ResourceUrlEncodingFilter
extends GenericFilterBean {
    private static final Log logger = LogFactory.getLog(ResourceUrlEncodingFilter.class);

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("ResourceUrlEncodingFilter only supports HTTP requests");
        }
        ResourceUrlEncodingRequestWrapper wrappedRequest = new ResourceUrlEncodingRequestWrapper((HttpServletRequest)request);
        ResourceUrlEncodingResponseWrapper wrappedResponse = new ResourceUrlEncodingResponseWrapper(wrappedRequest, (HttpServletResponse)response);
        filterChain.doFilter(wrappedRequest, wrappedResponse);
    }

    private static class ResourceUrlEncodingResponseWrapper
    extends HttpServletResponseWrapper {
        private final ResourceUrlEncodingRequestWrapper request;

        ResourceUrlEncodingResponseWrapper(ResourceUrlEncodingRequestWrapper request, HttpServletResponse wrapped) {
            super(wrapped);
            this.request = request;
        }

        @Override
        public String encodeURL(String url) {
            String urlPath = this.request.resolveUrlPath(url);
            if (urlPath != null) {
                return super.encodeURL(urlPath);
            }
            return super.encodeURL(url);
        }
    }

    private static class ResourceUrlEncodingRequestWrapper
    extends HttpServletRequestWrapper {
        @Nullable
        private ResourceUrlProvider resourceUrlProvider;
        @Nullable
        private Integer indexLookupPath;
        private String prefixLookupPath = "";

        ResourceUrlEncodingRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        @Override
        public void setAttribute(String name, Object value) {
            super.setAttribute(name, value);
            if (ResourceUrlProviderExposingInterceptor.RESOURCE_URL_PROVIDER_ATTR.equals(name) && value instanceof ResourceUrlProvider) {
                this.initLookupPath((ResourceUrlProvider)value);
            }
        }

        private void initLookupPath(ResourceUrlProvider urlProvider) {
            this.resourceUrlProvider = urlProvider;
            if (this.indexLookupPath == null) {
                String contextPath;
                UrlPathHelper pathHelper = this.resourceUrlProvider.getUrlPathHelper();
                String requestUri = pathHelper.getRequestUri(this);
                String lookupPath = pathHelper.getLookupPathForRequest(this);
                this.indexLookupPath = requestUri.lastIndexOf(lookupPath);
                this.prefixLookupPath = requestUri.substring(0, this.indexLookupPath);
                if ("/".equals(lookupPath) && !"/".equals(requestUri) && requestUri.equals(contextPath = pathHelper.getContextPath(this))) {
                    this.indexLookupPath = requestUri.length();
                    this.prefixLookupPath = requestUri;
                }
            }
        }

        @Nullable
        public String resolveUrlPath(String url) {
            if (this.resourceUrlProvider == null) {
                logger.trace("ResourceUrlProvider not available via request attribute ResourceUrlProviderExposingInterceptor.RESOURCE_URL_PROVIDER_ATTR");
                return null;
            }
            if (this.indexLookupPath != null && url.startsWith(this.prefixLookupPath)) {
                int suffixIndex = this.getQueryParamsIndex(url);
                String suffix = url.substring(suffixIndex);
                String lookupPath = url.substring(this.indexLookupPath, suffixIndex);
                if ((lookupPath = this.resourceUrlProvider.getForLookupPath(lookupPath)) != null) {
                    return this.prefixLookupPath + lookupPath + suffix;
                }
            }
            return null;
        }

        private int getQueryParamsIndex(String url) {
            int index = url.indexOf(63);
            return index > 0 ? index : url.length();
        }
    }
}

