/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.resource;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationContext;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationListener;
import com.baidu.cloud.thirdparty.springframework.context.event.ContextRefreshedEvent;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAwareOrderComparator;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.AntPathMatcher;
import com.baidu.cloud.thirdparty.springframework.util.PathMatcher;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.DefaultResourceResolverChain;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import com.baidu.cloud.thirdparty.springframework.web.util.UrlPathHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResourceUrlProvider
implements ApplicationListener<ContextRefreshedEvent> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private final Map<String, ResourceHttpRequestHandler> handlerMap = new LinkedHashMap<String, ResourceHttpRequestHandler>();
    private boolean autodetect = true;

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setHandlerMap(@Nullable Map<String, ResourceHttpRequestHandler> handlerMap) {
        if (handlerMap != null) {
            this.handlerMap.clear();
            this.handlerMap.putAll(handlerMap);
            this.autodetect = false;
        }
    }

    public Map<String, ResourceHttpRequestHandler> getHandlerMap() {
        return this.handlerMap;
    }

    public boolean isAutodetect() {
        return this.autodetect;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.isAutodetect()) {
            this.handlerMap.clear();
            this.detectResourceHandlers(event.getApplicationContext());
            if (this.handlerMap.isEmpty() && this.logger.isDebugEnabled()) {
                this.logger.debug("No resource handling mappings found");
            }
            if (!this.handlerMap.isEmpty()) {
                this.autodetect = false;
            }
        }
    }

    protected void detectResourceHandlers(ApplicationContext appContext) {
        this.logger.debug("Looking for resource handler mappings");
        Map<String, SimpleUrlHandlerMapping> beans2 = appContext.getBeansOfType(SimpleUrlHandlerMapping.class);
        ArrayList<SimpleUrlHandlerMapping> mappings = new ArrayList<SimpleUrlHandlerMapping>(beans2.values());
        AnnotationAwareOrderComparator.sort(mappings);
        for (SimpleUrlHandlerMapping mapping : mappings) {
            for (String pattern : mapping.getHandlerMap().keySet()) {
                Object handler = mapping.getHandlerMap().get(pattern);
                if (!(handler instanceof ResourceHttpRequestHandler)) continue;
                ResourceHttpRequestHandler resourceHandler = (ResourceHttpRequestHandler)handler;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found resource handler mapping: URL pattern=\"" + pattern + "\", locations=" + resourceHandler.getLocations() + ", resolvers=" + resourceHandler.getResourceResolvers());
                }
                this.handlerMap.put(pattern, resourceHandler);
            }
        }
    }

    @Nullable
    public final String getForRequestUrl(HttpServletRequest request, String requestUrl) {
        int suffixIndex;
        int prefixIndex;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Getting resource URL for request URL \"" + requestUrl + "\"");
        }
        if ((prefixIndex = this.getLookupPathIndex(request)) >= (suffixIndex = this.getEndPathIndex(requestUrl))) {
            return null;
        }
        String prefix = requestUrl.substring(0, prefixIndex);
        String suffix = requestUrl.substring(suffixIndex);
        String lookupPath = requestUrl.substring(prefixIndex, suffixIndex);
        String resolvedLookupPath = this.getForLookupPath(lookupPath);
        return resolvedLookupPath != null ? prefix + resolvedLookupPath + suffix : null;
    }

    private int getLookupPathIndex(HttpServletRequest request) {
        UrlPathHelper pathHelper = this.getUrlPathHelper();
        String requestUri = pathHelper.getRequestUri(request);
        String lookupPath = pathHelper.getLookupPathForRequest(request);
        return requestUri.indexOf(lookupPath);
    }

    private int getEndPathIndex(String lookupPath) {
        int hashIndex;
        int suffixIndex = lookupPath.length();
        int queryIndex = lookupPath.indexOf(63);
        if (queryIndex > 0) {
            suffixIndex = queryIndex;
        }
        if ((hashIndex = lookupPath.indexOf(35)) > 0) {
            suffixIndex = Math.min(suffixIndex, hashIndex);
        }
        return suffixIndex;
    }

    @Nullable
    public final String getForLookupPath(String lookupPath) {
        String previous;
        do {
            previous = lookupPath;
        } while (!(lookupPath = StringUtils.replace(lookupPath, "//", "/")).equals(previous));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Getting resource URL for lookup path \"" + lookupPath + "\"");
        }
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        for (String pattern : this.handlerMap.keySet()) {
            if (!this.getPathMatcher().match(pattern, lookupPath)) continue;
            matchingPatterns.add(pattern);
        }
        if (!matchingPatterns.isEmpty()) {
            Comparator<String> patternComparator = this.getPathMatcher().getPatternComparator(lookupPath);
            matchingPatterns.sort(patternComparator);
            for (String pattern : matchingPatterns) {
                ResourceHttpRequestHandler handler;
                DefaultResourceResolverChain chain;
                String resolved;
                String pathWithinMapping = this.getPathMatcher().extractPathWithinPattern(pattern, lookupPath);
                String pathMapping = lookupPath.substring(0, lookupPath.indexOf(pathWithinMapping));
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Invoking ResourceResolverChain for URL pattern \"" + pattern + "\"");
                }
                if ((resolved = (chain = new DefaultResourceResolverChain((handler = this.handlerMap.get(pattern)).getResourceResolvers())).resolveUrlPath(pathWithinMapping, handler.getLocations())) == null) continue;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Resolved public resource URL path \"" + resolved + "\"");
                }
                return pathMapping + resolved;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("No matching resource mapping for lookup path \"" + lookupPath + "\"");
        }
        return null;
    }
}

