/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.support;

import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.context.i18n.LocaleContext;
import com.baidu.cloud.thirdparty.springframework.context.i18n.TimeZoneAwareLocaleContext;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.ui.context.Theme;
import com.baidu.cloud.thirdparty.springframework.ui.context.ThemeSource;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.web.context.ContextLoader;
import com.baidu.cloud.thirdparty.springframework.web.context.WebApplicationContext;
import com.baidu.cloud.thirdparty.springframework.web.context.support.WebApplicationContextUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.DispatcherServlet;
import com.baidu.cloud.thirdparty.springframework.web.servlet.FlashMap;
import com.baidu.cloud.thirdparty.springframework.web.servlet.FlashMapManager;
import com.baidu.cloud.thirdparty.springframework.web.servlet.LocaleContextResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.LocaleResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.ThemeResolver;
import com.baidu.cloud.thirdparty.springframework.web.util.UriComponents;
import com.baidu.cloud.thirdparty.springframework.web.util.UriComponentsBuilder;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public abstract class RequestContextUtils {
    public static final String REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME = "requestDataValueProcessor";

    @Nullable
    public static WebApplicationContext findWebApplicationContext(HttpServletRequest request, @Nullable ServletContext servletContext) {
        WebApplicationContext webApplicationContext = (WebApplicationContext)request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (webApplicationContext == null) {
            if (servletContext != null) {
                webApplicationContext = WebApplicationContextUtils.getWebApplicationContext(servletContext);
            }
            if (webApplicationContext == null) {
                webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
            }
        }
        return webApplicationContext;
    }

    @Nullable
    public static WebApplicationContext findWebApplicationContext(HttpServletRequest request) {
        return RequestContextUtils.findWebApplicationContext(request, request.getServletContext());
    }

    @Nullable
    public static LocaleResolver getLocaleResolver(HttpServletRequest request) {
        return (LocaleResolver)request.getAttribute(DispatcherServlet.LOCALE_RESOLVER_ATTRIBUTE);
    }

    public static Locale getLocale(HttpServletRequest request) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(request);
        return localeResolver != null ? localeResolver.resolveLocale(request) : request.getLocale();
    }

    @Nullable
    public static TimeZone getTimeZone(HttpServletRequest request) {
        LocaleContext localeContext;
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(request);
        if (localeResolver instanceof LocaleContextResolver && (localeContext = ((LocaleContextResolver)localeResolver).resolveLocaleContext(request)) instanceof TimeZoneAwareLocaleContext) {
            return ((TimeZoneAwareLocaleContext)localeContext).getTimeZone();
        }
        return null;
    }

    @Nullable
    public static ThemeResolver getThemeResolver(HttpServletRequest request) {
        return (ThemeResolver)request.getAttribute(DispatcherServlet.THEME_RESOLVER_ATTRIBUTE);
    }

    @Nullable
    public static ThemeSource getThemeSource(HttpServletRequest request) {
        return (ThemeSource)request.getAttribute(DispatcherServlet.THEME_SOURCE_ATTRIBUTE);
    }

    @Nullable
    public static Theme getTheme(HttpServletRequest request) {
        ThemeResolver themeResolver = RequestContextUtils.getThemeResolver(request);
        ThemeSource themeSource = RequestContextUtils.getThemeSource(request);
        if (themeResolver != null && themeSource != null) {
            String themeName = themeResolver.resolveThemeName(request);
            return themeSource.getTheme(themeName);
        }
        return null;
    }

    @Nullable
    public static Map<String, ?> getInputFlashMap(HttpServletRequest request) {
        return (Map)request.getAttribute(DispatcherServlet.INPUT_FLASH_MAP_ATTRIBUTE);
    }

    public static FlashMap getOutputFlashMap(HttpServletRequest request) {
        return (FlashMap)request.getAttribute(DispatcherServlet.OUTPUT_FLASH_MAP_ATTRIBUTE);
    }

    @Nullable
    public static FlashMapManager getFlashMapManager(HttpServletRequest request) {
        return (FlashMapManager)request.getAttribute(DispatcherServlet.FLASH_MAP_MANAGER_ATTRIBUTE);
    }

    public static void saveOutputFlashMap(String location, HttpServletRequest request, HttpServletResponse response) {
        FlashMap flashMap = RequestContextUtils.getOutputFlashMap(request);
        if (CollectionUtils.isEmpty(flashMap)) {
            return;
        }
        UriComponents uriComponents = UriComponentsBuilder.fromUriString(location).build();
        flashMap.setTargetRequestPath(uriComponents.getPath());
        flashMap.addTargetRequestParams(uriComponents.getQueryParams());
        FlashMapManager manager = RequestContextUtils.getFlashMapManager(request);
        Assert.state(manager != null, "No FlashMapManager. Is this a DispatcherServlet handled request?");
        manager.saveOutputFlashMap(flashMap, request, response);
    }
}

