/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.tags;

import com.baidu.cloud.thirdparty.servlet.jsp.JspException;
import com.baidu.cloud.thirdparty.servlet.jsp.PageContext;
import com.baidu.cloud.thirdparty.servlet.jsp.el.VariableResolver;
import com.baidu.cloud.thirdparty.springframework.context.expression.BeanFactoryResolver;
import com.baidu.cloud.thirdparty.springframework.context.expression.EnvironmentAccessor;
import com.baidu.cloud.thirdparty.springframework.context.expression.MapAccessor;
import com.baidu.cloud.thirdparty.springframework.core.convert.ConversionService;
import com.baidu.cloud.thirdparty.springframework.expression.AccessException;
import com.baidu.cloud.thirdparty.springframework.expression.EvaluationContext;
import com.baidu.cloud.thirdparty.springframework.expression.Expression;
import com.baidu.cloud.thirdparty.springframework.expression.ExpressionParser;
import com.baidu.cloud.thirdparty.springframework.expression.PropertyAccessor;
import com.baidu.cloud.thirdparty.springframework.expression.TypedValue;
import com.baidu.cloud.thirdparty.springframework.expression.spel.standard.SpelExpressionParser;
import com.baidu.cloud.thirdparty.springframework.expression.spel.support.StandardEvaluationContext;
import com.baidu.cloud.thirdparty.springframework.expression.spel.support.StandardTypeConverter;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.ObjectUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import com.baidu.cloud.thirdparty.springframework.web.util.JavaScriptUtils;
import com.baidu.cloud.thirdparty.springframework.web.util.TagUtils;
import java.io.IOException;

public class EvalTag
extends HtmlEscapingAwareTag {
    private static final String EVALUATION_CONTEXT_PAGE_ATTRIBUTE = "com.baidu.cloud.thirdparty.springframework.web.servlet.tags.EVALUATION_CONTEXT";
    private final ExpressionParser expressionParser = new SpelExpressionParser();
    @Nullable
    private Expression expression;
    @Nullable
    private String var;
    private int scope = 1;
    private boolean javaScriptEscape = false;

    public void setExpression(String expression) {
        this.expression = this.expressionParser.parseExpression(expression);
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = TagUtils.getScope(scope);
    }

    public void setJavaScriptEscape(boolean javaScriptEscape) throws JspException {
        this.javaScriptEscape = javaScriptEscape;
    }

    @Override
    public int doStartTagInternal() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        EvaluationContext evaluationContext = (EvaluationContext)this.pageContext.getAttribute(EVALUATION_CONTEXT_PAGE_ATTRIBUTE);
        if (evaluationContext == null) {
            evaluationContext = this.createEvaluationContext(this.pageContext);
            this.pageContext.setAttribute(EVALUATION_CONTEXT_PAGE_ATTRIBUTE, (Object)evaluationContext);
        }
        if (this.var != null) {
            Object result = this.expression != null ? this.expression.getValue(evaluationContext) : null;
            this.pageContext.setAttribute(this.var, result, this.scope);
        } else {
            try {
                String result = this.expression != null ? this.expression.getValue(evaluationContext, String.class) : null;
                result = ObjectUtils.getDisplayString(result);
                result = this.htmlEscape(result);
                result = this.javaScriptEscape ? JavaScriptUtils.javaScriptEscape(result) : result;
                this.pageContext.getOut().print(result);
            }
            catch (IOException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        return 6;
    }

    private EvaluationContext createEvaluationContext(PageContext pageContext) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.addPropertyAccessor(new JspPropertyAccessor(pageContext));
        context.addPropertyAccessor(new MapAccessor());
        context.addPropertyAccessor(new EnvironmentAccessor());
        context.setBeanResolver(new BeanFactoryResolver(this.getRequestContext().getWebApplicationContext()));
        ConversionService conversionService = this.getConversionService(pageContext);
        if (conversionService != null) {
            context.setTypeConverter(new StandardTypeConverter(conversionService));
        }
        return context;
    }

    @Nullable
    private ConversionService getConversionService(PageContext pageContext) {
        return (ConversionService)pageContext.getRequest().getAttribute(ConversionService.class.getName());
    }

    private static class JspPropertyAccessor
    implements PropertyAccessor {
        private final PageContext pageContext;
        @Nullable
        private final VariableResolver variableResolver;

        public JspPropertyAccessor(PageContext pageContext) {
            this.pageContext = pageContext;
            this.variableResolver = pageContext.getVariableResolver();
        }

        @Override
        @Nullable
        public Class<?>[] getSpecificTargetClasses() {
            return null;
        }

        @Override
        public boolean canRead(EvaluationContext context, @Nullable Object target, String name) throws AccessException {
            return target == null && (this.resolveImplicitVariable(name) != null || this.pageContext.findAttribute(name) != null);
        }

        @Override
        public TypedValue read(EvaluationContext context, @Nullable Object target, String name) throws AccessException {
            Object implicitVar = this.resolveImplicitVariable(name);
            if (implicitVar != null) {
                return new TypedValue(implicitVar);
            }
            return new TypedValue(this.pageContext.findAttribute(name));
        }

        @Override
        public boolean canWrite(EvaluationContext context, @Nullable Object target, String name) {
            return false;
        }

        @Override
        public void write(EvaluationContext context, @Nullable Object target, String name, @Nullable Object newValue) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        private Object resolveImplicitVariable(String name) throws AccessException {
            if (this.variableResolver == null) {
                return null;
            }
            try {
                return this.variableResolver.resolveVariable(name);
            }
            catch (Exception ex) {
                throw new AccessException("Unexpected exception occurred accessing '" + name + "' as an implicit variable", ex);
            }
        }
    }
}

