/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.tags.form;

import com.baidu.cloud.thirdparty.servlet.jsp.JspException;
import com.baidu.cloud.thirdparty.servlet.jsp.tagext.BodyTag;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ObjectUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.tags.form.AbstractHtmlElementBodyTag;
import com.baidu.cloud.thirdparty.springframework.web.servlet.tags.form.FormTag;
import com.baidu.cloud.thirdparty.springframework.web.servlet.tags.form.TagWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class ErrorsTag
extends AbstractHtmlElementBodyTag
implements BodyTag {
    public static final String MESSAGES_ATTRIBUTE = "messages";
    public static final String SPAN_TAG = "span";
    private String element = "span";
    private String delimiter = "<br/>";
    @Nullable
    private Object oldMessages;
    private boolean errorMessagesWereExposed;

    public void setElement(String element) {
        Assert.hasText(element, "'element' cannot be null or blank");
        this.element = element;
    }

    public String getElement() {
        return this.element;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    protected String autogenerateId() throws JspException {
        String path = this.getPropertyPath();
        if ("".equals(path) || "*".equals(path)) {
            path = (String)this.pageContext.getAttribute(FormTag.MODEL_ATTRIBUTE_VARIABLE_NAME, 2);
        }
        return StringUtils.deleteAny(path, "[]") + ".errors";
    }

    @Override
    @Nullable
    protected String getName() throws JspException {
        return null;
    }

    @Override
    protected boolean shouldRender() throws JspException {
        try {
            return this.getBindStatus().isError();
        }
        catch (IllegalStateException ex) {
            return false;
        }
    }

    @Override
    protected void renderDefaultContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag(this.getElement());
        this.writeDefaultAttributes(tagWriter);
        String delimiter = ObjectUtils.getDisplayString(this.evaluate("delimiter", this.getDelimiter()));
        String[] errorMessages = this.getBindStatus().getErrorMessages();
        for (int i = 0; i < errorMessages.length; ++i) {
            String errorMessage = errorMessages[i];
            if (i > 0) {
                tagWriter.appendValue(delimiter);
            }
            tagWriter.appendValue(this.getDisplayString(errorMessage));
        }
        tagWriter.endTag();
    }

    @Override
    protected void exposeAttributes() throws JspException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        errorMessages.addAll(Arrays.asList(this.getBindStatus().getErrorMessages()));
        this.oldMessages = this.pageContext.getAttribute(MESSAGES_ATTRIBUTE, 1);
        this.pageContext.setAttribute(MESSAGES_ATTRIBUTE, errorMessages, 1);
        this.errorMessagesWereExposed = true;
    }

    @Override
    protected void removeAttributes() {
        if (this.errorMessagesWereExposed) {
            if (this.oldMessages != null) {
                this.pageContext.setAttribute(MESSAGES_ATTRIBUTE, this.oldMessages, 1);
                this.oldMessages = null;
            } else {
                this.pageContext.removeAttribute(MESSAGES_ATTRIBUTE, 1);
            }
        }
    }
}

