/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.view;

import com.baidu.cloud.thirdparty.springframework.beans.BeansException;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationContext;
import com.baidu.cloud.thirdparty.springframework.core.Ordered;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.web.context.support.WebApplicationObjectSupport;
import com.baidu.cloud.thirdparty.springframework.web.servlet.View;
import com.baidu.cloud.thirdparty.springframework.web.servlet.ViewResolver;
import java.util.Locale;

public class BeanNameViewResolver
extends WebApplicationObjectSupport
implements ViewResolver,
Ordered {
    private int order = Integer.MAX_VALUE;

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    @Nullable
    public View resolveViewName(String viewName, Locale locale) throws BeansException {
        ApplicationContext context = this.obtainApplicationContext();
        if (!context.containsBean(viewName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No matching bean found for view name '" + viewName + "'");
            }
            return null;
        }
        if (!context.isTypeMatch(viewName, View.class)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found matching bean for view name '" + viewName + "' - to be ignored since it does not implement View");
            }
            return null;
        }
        return context.getBean(viewName, View.class);
    }
}

