/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.uuid;

import com.baidu.cloud.thirdparty.uuid.EthernetAddress;
import com.baidu.cloud.thirdparty.uuid.TagURI;
import com.baidu.cloud.thirdparty.uuid.TimestampSynchronizer;
import com.baidu.cloud.thirdparty.uuid.UUID;
import com.baidu.cloud.thirdparty.uuid.UUIDTimer;
import java.io.IOException;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;

public final class UUIDGenerator {
    private static final UUIDGenerator sSingleton = new UUIDGenerator();
    private Random mRnd = null;
    private final Object mDummyAddressLock = new Object();
    private EthernetAddress mDummyAddress = null;
    private final Object mTimerLock = new Object();
    private UUIDTimer mTimer = null;
    private MessageDigest mHasher = null;

    private UUIDGenerator() {
    }

    public static UUIDGenerator getInstance() {
        return sSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeExternally(TimestampSynchronizer timestampSynchronizer) throws IOException {
        Object object = this.mTimerLock;
        synchronized (object) {
            if (this.mTimer == null) {
                this.mTimer = new UUIDTimer(this.getRandomNumberGenerator());
            }
            this.mTimer.setSynchronizer(timestampSynchronizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EthernetAddress getDummyAddress() {
        Object object = this.mDummyAddressLock;
        synchronized (object) {
            if (this.mDummyAddress == null) {
                Random random = this.getRandomNumberGenerator();
                byte[] byArray = new byte[6];
                random.nextBytes(byArray);
                byArray[0] = (byte)(byArray[0] | 1);
                try {
                    this.mDummyAddress = new EthernetAddress(byArray);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.mDummyAddress;
    }

    public Random getRandomNumberGenerator() {
        if (this.mRnd == null) {
            this.mRnd = new SecureRandom();
        }
        return this.mRnd;
    }

    public void setRandomNumberGenerator(Random random) {
        this.mRnd = random;
    }

    public MessageDigest getHashAlgorithm() {
        if (this.mHasher == null) {
            try {
                this.mHasher = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new Error("Couldn't instantiate an MD5 MessageDigest instance: " + noSuchAlgorithmException.toString());
            }
        }
        return this.mHasher;
    }

    public UUID generateRandomBasedUUID() {
        return this.generateRandomBasedUUID(this.getRandomNumberGenerator());
    }

    public UUID generateRandomBasedUUID(Random random) {
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        return new UUID(4, byArray);
    }

    public UUID generateTimeBasedUUID() {
        return this.generateTimeBasedUUID(this.getDummyAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID generateTimeBasedUUID(EthernetAddress ethernetAddress) {
        byte[] byArray = new byte[16];
        ethernetAddress.toByteArray(byArray, 10);
        Object object = this.mTimerLock;
        synchronized (object) {
            if (this.mTimer == null) {
                this.mTimer = new UUIDTimer(this.getRandomNumberGenerator());
            }
            this.mTimer.getTimestamp(byArray);
        }
        return new UUID(1, byArray);
    }

    public UUID generateNameBasedUUID(UUID uUID, String string, MessageDigest messageDigest) {
        messageDigest.reset();
        if (uUID != null) {
            messageDigest.update(uUID.asByteArray());
        }
        messageDigest.update(string.getBytes());
        return new UUID(3, messageDigest.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID generateNameBasedUUID(UUID uUID, String string) {
        MessageDigest messageDigest;
        MessageDigest messageDigest2 = messageDigest = this.getHashAlgorithm();
        synchronized (messageDigest2) {
            return this.generateNameBasedUUID(uUID, string, this.getHashAlgorithm());
        }
    }

    public UUID generateTagURIBasedUUID(TagURI tagURI) {
        return this.generateNameBasedUUID(null, tagURI.toString());
    }

    public UUID generateTagURIBasedUUID(TagURI tagURI, MessageDigest messageDigest) {
        return this.generateNameBasedUUID(null, tagURI.toString(), messageDigest);
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        UUIDGenerator uUIDGenerator = UUIDGenerator.getInstance();
        UUID uUID = new UUID("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
        System.out.println("UUIDGenerator.main()");
        System.out.println();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        ArrayList arrayList = new ArrayList(4);
        for (n = 0; n < 4; ++n) {
            System.out.print("Random UUID: ");
            object = uUIDGenerator.generateRandomBasedUUID();
            treeSet.add(object);
            UUIDGenerator.doTest((UUID)object, System.out, 4);
            System.out.print("Time-based UUID: ");
            object = uUIDGenerator.generateTimeBasedUUID();
            treeSet.add(object);
            arrayList.add(object);
            UUIDGenerator.doTest((UUID)object, System.out, 1);
            String string = "test-round-" + n;
            System.out.print("Named-based UUID: (namespace URL, name '" + string + "')");
            object = uUIDGenerator.generateNameBasedUUID(uUID, string);
            treeSet.add(object);
            UUIDGenerator.doTest((UUID)object, System.out, 3);
        }
        n = treeSet.size();
        System.out.print("Created 12 uuids; ordered treeset contains " + n);
        System.out.println(n == 12 ? " [OK]" : " [FAIL]");
        System.out.println("Checking ordering:");
        object = treeSet.iterator();
        int n2 = -1;
        System.out.print("Overall ordering by type: ");
        while (object.hasNext()) {
            System.out.print(".");
            UUID uUID2 = (UUID)object.next();
            int n3 = uUID2.getType();
            if (n3 < n2) break;
            n2 = n3;
        }
        System.out.println(object.hasNext() ? "FAIL" : "OK");
        object = treeSet.iterator();
        int n4 = -1;
        System.out.print("Time-based UUID ordering on creation time: ");
        while (object.hasNext()) {
            UUID uUID3 = (UUID)object.next();
            int n5 = arrayList.indexOf(uUID3);
            if (n5 < 0) continue;
            System.out.print("[");
            System.out.print(n5);
            System.out.print("]");
            if (n5 > n4) continue;
        }
        System.out.println(object.hasNext() ? "FAIL" : "OK");
        UUIDGenerator.doTestNull();
    }

    private static final void doTest(UUID uUID, PrintStream printStream, int n) {
        UUID uUID2;
        System.out.print(uUID.toString());
        System.out.print(" [type: " + uUID.getType());
        System.out.print(", expected " + n);
        System.out.print(n == uUID.getType() ? ": OK" : ": FAIL");
        System.out.println("]");
        System.out.print("... conversion UUID<->String: ");
        try {
            uUID2 = UUID.valueOf(uUID.toString());
            System.out.println(uUID2.toString());
            System.out.print("  -> ");
            System.out.println(uUID.equals(uUID2) ? "OK" : "FAIL");
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("[FAIL: " + numberFormatException.toString() + "]");
        }
        System.out.print("... conversion UUID<->byte array: ");
        uUID2 = UUID.valueOf(uUID.asByteArray());
        System.out.println(uUID2.toString());
        System.out.print("  -> ");
        System.out.println(uUID.equals(uUID2) ? "OK" : "FAIL");
        System.out.print("... considered null? ");
        boolean bl = uUID.isNullUUID();
        System.out.print(bl);
        System.out.print(" (shouldn't be) -> ");
        System.out.println(bl ? "FAIL" : "OK");
    }

    private static final void doTestNull() {
        UUID uUID = UUID.getNullUUID();
        System.out.println("Testing null UUID checks:");
        System.out.print("Testing shared null uuid; considered null: ");
        boolean bl = uUID.isNullUUID();
        System.out.print(bl);
        System.out.print("; expected true -> ");
        System.out.println(bl ? "OK" : "FAIL");
        UUID uUID2 = new UUID(new byte[16]);
        System.out.print("Testing explicit null uuid; considered null: ");
        bl = uUID2.isNullUUID();
        System.out.print(bl);
        System.out.print("; expected true -> ");
        System.out.println(bl ? "OK" : "FAIL");
    }
}

