/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.uuid;

import com.baidu.cloud.thirdparty.uuid.Logger;
import com.baidu.cloud.thirdparty.uuid.TimestampSynchronizer;
import java.io.IOException;
import java.util.Random;

public class UUIDTimer {
    private static final long kClockOffset = 122192928000000000L;
    private static final long kClockMultiplier = 10000L;
    private static final long kClockMultiplierL = 10000L;
    private static final long kMaxClockAdvance = 100L;
    private final Random mRnd;
    private final byte[] mClockSequence = new byte[3];
    private long mLastSystemTimestamp = 0L;
    private long mLastUsedTimestamp = 0L;
    private long mFirstUnsafeTimestamp = Long.MAX_VALUE;
    private int mClockCounter = 0;
    private TimestampSynchronizer mSync = null;
    private static final int MAX_WAIT_COUNT = 50;

    UUIDTimer(Random random) {
        this.mRnd = random;
        this.initCounters(random);
        this.mLastSystemTimestamp = 0L;
        this.mLastUsedTimestamp = 0L;
    }

    private void initCounters(Random random) {
        random.nextBytes(this.mClockSequence);
        this.mClockCounter = this.mClockSequence[2] & 0xFF;
    }

    public void getTimestamp(byte[] byArray) {
        byArray[8] = this.mClockSequence[0];
        byArray[9] = this.mClockSequence[1];
        long l = System.currentTimeMillis();
        if (l < this.mLastSystemTimestamp) {
            Logger.logWarning("System time going backwards! (got value " + l + ", last " + this.mLastSystemTimestamp);
            this.mLastSystemTimestamp = l;
        }
        if (l <= this.mLastUsedTimestamp) {
            if ((long)this.mClockCounter < 10000L) {
                l = this.mLastUsedTimestamp;
            } else {
                long l2 = this.mLastUsedTimestamp - l;
                long l3 = l;
                l = this.mLastUsedTimestamp + 1L;
                Logger.logWarning("Timestamp over-run: need to reinitialize random sequence");
                this.initCounters(this.mRnd);
                if (l2 >= 100L) {
                    UUIDTimer.slowDown(l3, l2);
                }
            }
        } else {
            this.mClockCounter &= 0xFF;
        }
        this.mLastUsedTimestamp = l;
        if (this.mSync != null && l >= this.mFirstUnsafeTimestamp) {
            try {
                this.mFirstUnsafeTimestamp = this.mSync.update(l);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to synchronize timestamp: " + iOException);
            }
        }
        l *= 10000L;
        l += 122192928000000000L;
        ++this.mClockCounter;
        int n = (int)((l += (long)this.mClockCounter) >>> 32);
        int n2 = (int)l;
        byArray[6] = (byte)(n >>> 24);
        byArray[7] = (byte)(n >>> 16);
        byArray[4] = (byte)(n >>> 8);
        byArray[5] = (byte)n;
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)n2;
    }

    public void setSynchronizer(TimestampSynchronizer timestampSynchronizer) throws IOException {
        long l;
        TimestampSynchronizer timestampSynchronizer2 = this.mSync;
        if (timestampSynchronizer2 != null) {
            try {
                timestampSynchronizer2.deactivate();
            }
            catch (IOException iOException) {
                Logger.logError("Failed to deactivate the old synchronizer: " + iOException);
            }
        }
        this.mSync = timestampSynchronizer;
        if (timestampSynchronizer != null && (l = timestampSynchronizer.initialize()) > this.mLastUsedTimestamp) {
            this.mLastUsedTimestamp = l;
        }
        this.mFirstUnsafeTimestamp = 0L;
    }

    private static final void slowDown(long l, long l2) {
        long l3 = l2 / 100L;
        long l4 = l3 < 2L ? 1L : (l3 < 10L ? 2L : (l3 < 600L ? 3L : 5L));
        Logger.logWarning("Need to wait for " + l4 + " milliseconds; virtual clock advanced too far in the future");
        long l5 = l + l4;
        int n = 0;
        do {
            try {
                Thread.sleep(l4);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l4 = 1L;
        } while (++n <= 50 && System.currentTimeMillis() < l5);
    }
}

