/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client;

import com.baidu.cloud.starlight.springcloud.client.RpcProxyAnnotationBeanPostProcessor;
import com.baidu.cloud.starlight.springcloud.client.annotation.RpcProxy;
import com.baidu.cloud.starlight.springcloud.client.cluster.LoadBalancer;
import com.baidu.cloud.starlight.springcloud.client.cluster.SingleStarlightClientManager;
import com.baidu.cloud.starlight.springcloud.client.cluster.loadbalance.SpringCloudLoadbalancer;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightRouteProperties;
import com.baidu.cloud.starlight.springcloud.common.ApplicationContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RpcProxy.class})
@EnableConfigurationProperties(value={StarlightClientProperties.class, StarlightRouteProperties.class})
public class StarlightClientAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarlightClientAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public RpcProxyAnnotationBeanPostProcessor rpcProxyBeanPostProcessor() {
        return new RpcProxyAnnotationBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationContextUtils applicationContextUtils() {
        return new ApplicationContextUtils();
    }

    @Bean(destroyMethod="destroyAll")
    @ConditionalOnMissingBean
    public SingleStarlightClientManager singleStarlightClientManager() {
        return SingleStarlightClientManager.getInstance();
    }

    @Bean
    @ConditionalOnMissingBean
    public LoadBalancer springCloudLoadBalancer(LoadBalancerClient loadBalancerClient) {
        SpringCloudLoadbalancer springCloudLoadbalancer = new SpringCloudLoadbalancer(loadBalancerClient);
        return springCloudLoadbalancer;
    }
}

