/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.cluster.route;

import com.baidu.cloud.starlight.api.rpc.RpcContext;
import com.baidu.cloud.starlight.springcloud.client.cluster.ClusterSelector;
import com.baidu.cloud.starlight.springcloud.client.cluster.SingleStarlightClientManager;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightRouteProperties;
import com.baidu.cloud.starlight.springcloud.client.ribbon.StarlightRibbonServer;
import com.baidu.cloud.starlight.springcloud.client.ribbon.StarlightServerListFilter;
import com.baidu.cloud.starlight.springcloud.common.SpringCloudConstants;
import com.baidu.cloud.thirdparty.netty.util.Timeout;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RoutableServerListFilter
implements StarlightServerListFilter<Server> {
    private final SingleStarlightClientManager clientManager;
    private final StarlightRouteProperties routeProperties;
    private final String name;

    public RoutableServerListFilter(SingleStarlightClientManager clientManager, StarlightRouteProperties routeProperties, String name) {
        this.clientManager = clientManager;
        this.routeProperties = routeProperties;
        this.name = name;
    }

    @Override
    public List<Server> getFilteredList(List<Server> servers) {
        if (!this.routeProperties.getEnabled().booleanValue()) {
            return servers;
        }
        if (servers == null || servers.size() == 0) {
            return servers;
        }
        Object obj = RpcContext.getContext().get("req_route_meta");
        if (!(obj instanceof ClusterSelector)) {
            return servers;
        }
        if (!(servers.get(0) instanceof StarlightRibbonServer)) {
            return servers;
        }
        ClusterSelector clusterSelector = (ClusterSelector)obj;
        List<Server> result = new ArrayList<Server>(servers);
        try {
            result = clusterSelector.selectorClusterInstances(result);
        }
        catch (Throwable e) {
            LOGGER.error("Route select instances for serviceId {} failed, clusterSelector {}.", new Object[]{this.name, clusterSelector.getClass().getSimpleName(), e});
            return servers;
        }
        RpcContext.getContext().remove("request_label_selector_route");
        return result;
    }

    @Override
    public Map<String, Timeout> getServerListFilterTasks() {
        return null;
    }

    @Override
    public void submitTimerTask(Server server, Integer execDelay) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public SingleStarlightClientManager getSingleClientManager() {
        return this.clientManager;
    }

    public int getOrder() {
        return SpringCloudConstants.ROUTE_SERVER_LIST_FILTER_ORDER;
    }
}

