/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.common;

import com.baidu.cloud.starlight.springcloud.server.properties.StarlightServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ApplicationContextUtils
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationContextUtils.class);
    private static final String[] WEB_ENVIRONMENT_CLASSES = new String[]{"javax.servlet.Servlet", "org.springframework.web.context.ConfigurableWebApplicationContext"};
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextUtils.applicationContext = applicationContext;
    }

    public static <T> T getBeanByType(Class<T> tClass) {
        if (tClass == null) {
            return null;
        }
        return (T)applicationContext.getBean(tClass);
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Environment getEnvironment() {
        return applicationContext.getEnvironment();
    }

    public static boolean isJarvisEnv() {
        String emProductLine = System.getenv("EM_PRODUCT_LINE");
        String emPlatform = System.getenv("EM_PLATFORM");
        String emApp = System.getenv("EM_APP");
        return !StringUtils.isEmpty((Object)emProductLine) && !StringUtils.isEmpty((Object)emPlatform) && !StringUtils.isEmpty((Object)emApp);
    }

    public static boolean deduceWebEnvironment() {
        for (String className : WEB_ENVIRONMENT_CLASSES) {
            if (ClassUtils.isPresent((String)className, null)) continue;
            return false;
        }
        if (ApplicationContextUtils.getEnvironment().getProperty("spring.main.web-application-type") != null && ApplicationContextUtils.getEnvironment().getProperty("spring.main.web-application-type").equalsIgnoreCase("none")) {
            return false;
        }
        return !(ApplicationContextUtils.getApplicationContext() instanceof AnnotationConfigApplicationContext);
    }

    public static Integer getServerPort() {
        StarlightServerProperties starlightServerProperties = ApplicationContextUtils.getBeanByType(StarlightServerProperties.class);
        Integer port = starlightServerProperties.getPort();
        if (!(port != null && port > 0 || ApplicationContextUtils.deduceWebEnvironment())) {
            port = Integer.parseInt(ApplicationContextUtils.getEnvironment().getProperty("server.port", "8080").trim());
        }
        if (port == null || port <= 0) {
            throw new IllegalArgumentException("The following two properties are all illegal, please check: {starlight.server.port} {server.port}");
        }
        return port;
    }

    public static String getApplicationName() {
        String appName = ApplicationContextUtils.getEnvironment().getProperty("starlight.server.name");
        if (StringUtils.isEmpty((Object)appName) && ApplicationContextUtils.isJarvisEnv()) {
            appName = System.getenv("EM_APP");
        }
        if (StringUtils.isEmpty((Object)appName)) {
            appName = ApplicationContextUtils.getEnvironment().getProperty("spring.application.name");
        }
        if (StringUtils.isEmpty((Object)appName)) {
            LOGGER.warn("The following three properties are all empty : {starlight.server.name} {spring.application.name}{EM_APP}, will use default value {application}");
            appName = "application";
        }
        return appName;
    }
}

