/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.server.register.consul;

import com.baidu.cloud.starlight.springcloud.server.register.StarlightRegisterListener;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StarlightConsulRegisterListener
extends StarlightRegisterListener {
    @Override
    protected Registration createStarlightRegistration() {
        ConsulDiscoveryProperties discoveryProperties = (ConsulDiscoveryProperties)this.applicationContext.getBean(ConsulDiscoveryProperties.class);
        HeartbeatProperties heartbeatProperties = (HeartbeatProperties)this.applicationContext.getBean(HeartbeatProperties.class);
        String appName = this.getAppName(this.applicationContext.getEnvironment());
        NewService service = new NewService();
        service.setName(appName);
        service.setId(this.getInstanceId(this.applicationContext.getEnvironment()));
        if (discoveryProperties.getInstanceId() != null) {
            service.setId(discoveryProperties.getInstanceId());
        }
        if (!discoveryProperties.isPreferAgentAddress()) {
            service.setAddress(discoveryProperties.getHostname());
        }
        service.setPort(this.getPort(this.applicationContext.getEnvironment()));
        service.setTags(ConsulAutoRegistration.createTags((ConsulDiscoveryProperties)discoveryProperties));
        LinkedList<String> tags = service.getTags();
        if (tags == null) {
            tags = new LinkedList<String>();
        }
        Map<String, String> starlightMetas = this.starlightMetas();
        for (Map.Entry<String, String> entry : starlightMetas.entrySet()) {
            tags.add(entry.getKey() + "=" + entry.getValue());
        }
        service.setCheck(StarlightConsulRegisterListener.createCheck(service.getPort(), heartbeatProperties, discoveryProperties));
        return new ConsulRegistration(service, discoveryProperties);
    }

    public static NewService.Check createCheck(Integer port, HeartbeatProperties ttlConfig, ConsulDiscoveryProperties properties) {
        NewService.Check check = new NewService.Check();
        if (ttlConfig.isEnabled()) {
            check.setTtl(ttlConfig.getTtl());
            check.setDeregisterCriticalServiceAfter("3m");
            if (StringUtils.hasText((String)properties.getHealthCheckCriticalTimeout())) {
                check.setDeregisterCriticalServiceAfter(properties.getHealthCheckCriticalTimeout());
            }
            return check;
        }
        Assert.notNull((Object)port, (String)"createCheck port must not be null");
        Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"createCheck port must be greater than 0");
        check.setTcp(String.format("%s:%s", properties.getHostname(), port));
        check.setInterval(properties.getHealthCheckInterval());
        check.setTimeout(properties.getHealthCheckTimeout());
        if (StringUtils.hasText((String)properties.getHealthCheckCriticalTimeout())) {
            check.setDeregisterCriticalServiceAfter(properties.getHealthCheckCriticalTimeout());
        }
        check.setTlsSkipVerify(properties.getHealthCheckTlsSkipVerify());
        return check;
    }
}

