/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.extension;

import com.baidu.cloud.starlight.api.extension.ClassLoadContext;
import com.baidu.cloud.starlight.api.extension.DefaultClassLoadStrategy;
import com.baidu.cloud.starlight.api.extension.IClassLoadStrategy;

public abstract class ClassLoaderResolver {
    private static IClassLoadStrategy s_strategy;
    private static final int CALL_CONTEXT_OFFSET = 3;
    private static final CallerResolver CALLER_RESOLVER;

    public static synchronized ClassLoader getClassLoader() {
        Class caller = ClassLoaderResolver.getCallerClass(0);
        ClassLoadContext ctx = new ClassLoadContext(caller);
        return s_strategy.getClassLoader(ctx);
    }

    static synchronized ClassLoader getClassLoader(int callerOffset) {
        Class caller = ClassLoaderResolver.getCallerClass(callerOffset);
        ClassLoadContext ctx = new ClassLoadContext(caller);
        return s_strategy.getClassLoader(ctx);
    }

    public static synchronized IClassLoadStrategy getStrategy() {
        return s_strategy;
    }

    public static synchronized IClassLoadStrategy setStrategy(IClassLoadStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("null input: strategy");
        }
        IClassLoadStrategy old = s_strategy;
        s_strategy = strategy;
        return old;
    }

    private ClassLoaderResolver() {
    }

    private static Class getCallerClass(int callerOffset) {
        return CALLER_RESOLVER.getClassContext()[3 + callerOffset];
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
        }
        catch (SecurityException se) {
            throw new RuntimeException("ClassLoaderResolver: could not create CallerResolver: " + se);
        }
        s_strategy = new DefaultClassLoadStrategy();
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

