/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.extension;

import com.baidu.cloud.starlight.api.extension.ResourceLoader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final String SERVICES_DIR = "META-INF/services/";
    private static final ConcurrentMap<Class<?>, ExtensionLoader<?>> EXTENSION_LOCATOR = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap();
    private final Class<?> type;
    private final ConcurrentMap<Class<?>, String> cachedNames = new ConcurrentHashMap();
    private final Map<String, Class<?>> cachedClasses = new HashMap();
    private final ConcurrentMap<String, Object> cachedInstances = new ConcurrentHashMap<String, Object>();
    private Map<String, IllegalStateException> exceptions = new ConcurrentHashMap<String, IllegalStateException>();

    public static <T> ExtensionLoader<T> getInstance(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        ExtensionLoader loader = (ExtensionLoader)EXTENSION_LOCATOR.get(type);
        if (loader == null) {
            EXTENSION_LOCATOR.putIfAbsent(type, new ExtensionLoader<T>(type));
            loader = (ExtensionLoader)EXTENSION_LOCATOR.get(type);
        }
        return loader;
    }

    private ExtensionLoader(Class<?> type) {
        this.type = type;
    }

    public String getExtensionName(T extensionInstance) {
        return this.getExtensionName(extensionInstance.getClass());
    }

    public String getExtensionName(Class<?> extensionClass) {
        return (String)this.cachedNames.get(extensionClass);
    }

    public synchronized T getExtension(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Object instance = this.cachedInstances.get(name);
        if (instance == null) {
            instance = this.createExtension(name);
            this.cachedInstances.putIfAbsent(name, instance);
        }
        return (T)instance;
    }

    public boolean hasExtension(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Extension name == null");
        }
        try {
            return this.getExtensionClass(name) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public Set<String> getSupportedExtensions() {
        Map<String, Class<?>> clazzes = this.getExtensionClasses();
        return Collections.unmodifiableSet(new TreeSet<String>(clazzes.keySet()));
    }

    public Set<String> getLoadedExtensions() {
        return Collections.unmodifiableSet(new TreeSet(this.cachedInstances.keySet()));
    }

    private IllegalStateException findException(String name) {
        for (Map.Entry<String, IllegalStateException> entry : this.exceptions.entrySet()) {
            if (!entry.getKey().toLowerCase().contains(name.toLowerCase())) continue;
            return entry.getValue();
        }
        StringBuilder buf = new StringBuilder("No such extension " + this.type.getName() + " by name " + name + ", possible causes: ");
        int i = 1;
        for (Map.Entry<String, IllegalStateException> entry : this.exceptions.entrySet()) {
            buf.append("\r\n(");
            buf.append(i++);
            buf.append(") ");
            buf.append(entry.getKey());
            buf.append(":\r\n");
            buf.append(entry.getValue());
        }
        return new IllegalStateException(buf.toString());
    }

    private T createExtension(String name) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw this.findException(name);
        }
        try {
            Object instance = EXTENSION_INSTANCES.get(clazz);
            if (instance == null) {
                EXTENSION_INSTANCES.putIfAbsent(clazz, clazz.newInstance());
                instance = EXTENSION_INSTANCES.get(clazz);
            }
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
        }
    }

    private Class<?> getExtensionClass(String name) {
        if (this.type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw new IllegalStateException("No such extension \"" + name + "\" for " + this.type.getName() + "!");
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> getExtensionClasses() {
        if (this.cachedClasses.size() == 0) {
            Map<String, Class<?>> map = this.cachedClasses;
            synchronized (map) {
                if (this.cachedClasses.size() == 0) {
                    this.cachedClasses.putAll(this.loadExtensionClasses());
                }
            }
        }
        return this.cachedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> loadExtensionClasses() {
        HashMap extensionClasses = new HashMap();
        String fileName = SERVICES_DIR + this.type.getName();
        try {
            Enumeration<URL> urls = ResourceLoader.getResources(fileName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        int ci = line.indexOf(35);
                        if (ci >= 0) {
                            line = line.substring(0, ci);
                        }
                        if ((line = line.trim()).length() <= 0) continue;
                        try {
                            Class c;
                            Class clazz;
                            String name = null;
                            int i = line.indexOf(61);
                            if (i > 0) {
                                name = line.substring(0, i).trim();
                                line = line.substring(i + 1).trim();
                            }
                            if (!this.type.isAssignableFrom(clazz = ResourceLoader.loadClass(line))) {
                                throw new IllegalStateException("Error when load extension class(interface: " + this.type + ", class line: " + clazz.getName() + "), class " + clazz.getName() + "is not subtype of interface.");
                            }
                            if (name == null || name.length() == 0) {
                                if (clazz.getSimpleName().length() > this.type.getSimpleName().length() && clazz.getSimpleName().endsWith(this.type.getSimpleName())) {
                                    name = clazz.getSimpleName().substring(0, clazz.getSimpleName().length() - this.type.getSimpleName().length()).toLowerCase();
                                } else if (clazz.getSimpleName().length() > this.type.getSimpleName().length() && clazz.getSimpleName().startsWith(this.type.getSimpleName())) {
                                    name = clazz.getSimpleName().substring(this.type.getSimpleName().length()).toLowerCase();
                                } else {
                                    throw new IllegalStateException("No such extension name for the class " + clazz.getName() + " in the config " + url);
                                }
                            }
                            if (!this.cachedNames.containsKey(clazz)) {
                                this.cachedNames.put(clazz, name);
                            }
                            if ((c = (Class)extensionClasses.get(name)) == null) {
                                extensionClasses.put(name, clazz);
                                continue;
                            }
                            if (c == clazz) continue;
                            throw new IllegalStateException("Duplicate extension " + this.type.getName() + " name " + name + " on " + c.getName() + " and " + clazz.getName());
                        }
                        catch (Throwable t) {
                            IllegalStateException e = new IllegalStateException("Failed to load extension class(interface: " + this.type + ", class line: " + line + ") in " + url + ", cause: " + t.getMessage(), t);
                            this.exceptions.put(line, e);
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.error("Exception when load extension class(interface: " + this.type + ", class file: " + url + ") in " + url, t);
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Exception when load extension class(interface: " + this.type + ", description file: " + fileName + ").", t);
        }
        return extensionClasses;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.type.getName() + "]";
    }
}

