/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.model;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.model.Response;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ResultFuture
implements Future {
    private CountDownLatch countDownLatch = new CountDownLatch(1);
    private Response response;

    public void putResponse(Response response) {
        this.response = response;
        this.countDownLatch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.countDownLatch.getCount() == 0L;
    }

    @Override
    public boolean isDone() {
        return this.response != null;
    }

    public Object get() throws InterruptedException, ExecutionException {
        this.countDownLatch.await();
        return this.result();
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.countDownLatch.await(timeout, unit);
        return this.result();
    }

    private Object result() {
        if (this.response.getStatus() != Constants.SUCCESS_CODE.intValue()) {
            if (this.response.getException() instanceof RuntimeException) {
                throw (RuntimeException)this.response.getException();
            }
            throw new StarlightRpcException(this.response.getStatus(), this.response.getErrorMsg(), this.response.getException());
        }
        return this.response.getResult();
    }
}

