/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.utils;

import com.baidu.cloud.starlight.api.model.MsgBase;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);
    protected static final String PROBE_SPAN_CONTEXT_KEY = "traceSpanContext";
    protected static final String X_B3_TRACE_ID = "X-B3-TraceId";
    protected static final String X_B3_SPAN_ID = "X-B3-SpanId";
    private static final String EQUAL_CHARACTER = "=";
    private static final String AND_CHARACTER = "&";
    public static final String TCID = "tcid";
    public static final String SPID = "spid";

    public static void addLogTimeAttachment(MsgBase msg, String timeKey, long timestamp) {
        if (msg.getNoneAdditionKv() == null) {
            msg.setNoneAdditionKv(new HashMap<String, Object>());
        }
        msg.getNoneAdditionKv().put(timeKey, timestamp);
    }

    public static void recordAccessLog(Request request, Response response) {
        String accessLogFormat = "[ACCLOG] recvTime {}, respTime {}, remoteName {}, remoteAddr {}, protocol {}, status {}, cost {}, req {}:{}, decReqHead {}, waitForExec {}, decodeReqBody {}, execServFilter {}, execMethod {}, encRespBody {}, waitForIoExec {}, encRespHead {}, tid {}, spid {}";
        try {
            Map<String, String> traceSpanIdMap = LogUtils.parseTraceIdSpanId(request);
            Long decodeRequestHeaderCost = request.getNoneAdditionKv().get("decode_header_cost") == null ? null : (Long)request.getNoneAdditionKv().get("decode_header_cost");
            Long decodeRequestBodyCost = request.getNoneAdditionKv().get("decode_body_cost") == null ? null : (Long)request.getNoneAdditionKv().get("decode_body_cost");
            Long waitForExecTime = request.getNoneAdditionKv().get("wait_for_thread_cost") == null ? null : (Long)request.getNoneAdditionKv().get("wait_for_thread_cost");
            Long executeMethodCost = request.getNoneAdditionKv().get("execute_method_cost") == null ? null : (Long)request.getNoneAdditionKv().get("execute_method_cost");
            Long encodeResponseBodyCost = response.getNoneAdditionKv().get("encode_body_cost") == null ? null : (Long)response.getNoneAdditionKv().get("encode_body_cost");
            Long encodeResponseHeaderCost = response.getNoneAdditionKv().get("encode_header_cost") == null ? null : (Long)response.getNoneAdditionKv().get("encode_header_cost");
            Long recvReqTime = request.getNoneAdditionKv().get("receive_byte_msg_time") == null ? null : (Long)request.getNoneAdditionKv().get("receive_byte_msg_time");
            Long retRespTime = response.getNoneAdditionKv().get("end_request_time") == null ? null : (Long)response.getNoneAdditionKv().get("end_request_time");
            Long serverExecCost = null;
            if (recvReqTime != null && retRespTime != null) {
                serverExecCost = retRespTime - recvReqTime;
            }
            LOGGER.info(accessLogFormat, new Object[]{recvReqTime == null ? null : LogUtils.timestampToString(recvReqTime), retRespTime == null ? null : LogUtils.timestampToString(retRespTime), request.getAttachmentKv().remove("consumer_app_name"), request.getNoneAdditionKv().get("remote_address"), request.getProtocolName(), response.getStatus(), serverExecCost, LogUtils.simpleServiceName(request.getServiceName()), request.getMethodName(), decodeRequestHeaderCost, waitForExecTime, decodeRequestBodyCost, request.getNoneAdditionKv().get("server_filter_exec_cost"), executeMethodCost, encodeResponseBodyCost, response.getNoneAdditionKv().get("wait_for_io_thread_cost"), encodeResponseHeaderCost, traceSpanIdMap.get(TCID), traceSpanIdMap.get(SPID)});
            LOGGER.debug("[ACCLOG] Request logKv {}, Response logKv {}", request.getNoneAdditionKv(), response.getNoneAdditionKv());
        }
        catch (Exception e) {
            LOGGER.warn("Record server access log error, cause by {}", (Object)e.getMessage());
        }
    }

    public static void recordRequestLog(Request request, Response response) {
        String requestLogFormat = "[REQLOG] reqTime {}, recvTime {}, remoteName {}, remoteAddr {}, protocol {}, status {}, cost {}, req {}:{}, encReqBody {}, waitForIoExec {}, encReqHead {}, serverExec {}, decRespHead {}, waitForExec {}, decRespBody {}, tid {}, spid {}";
        try {
            Map<String, String> traceSpanIdMap = LogUtils.parseTraceIdSpanId(request);
            Long encodeRequestBodyCost = request.getNoneAdditionKv().get("encode_body_cost") == null ? null : (Long)request.getNoneAdditionKv().get("encode_body_cost");
            Long encodeRequestHeaderCost = request.getNoneAdditionKv().get("encode_header_cost") == null ? null : (Long)request.getNoneAdditionKv().get("encode_header_cost");
            Long waitForThreadCost = response.getNoneAdditionKv().get("wait_for_thread_cost") == null ? null : (Long)response.getNoneAdditionKv().get("wait_for_thread_cost");
            Long decodeResponseHeaderCost = response.getNoneAdditionKv().get("decode_header_cost") == null ? null : (Long)response.getNoneAdditionKv().get("decode_header_cost");
            Long decodeResponseBodyCost = response.getNoneAdditionKv().get("decode_body_cost") == null ? null : (Long)response.getNoneAdditionKv().get("decode_body_cost");
            Long recvRespTime = response.getNoneAdditionKv().get("receive_byte_msg_time") == null ? null : (Long)response.getNoneAdditionKv().get("receive_byte_msg_time");
            Long beforeCallServerTime = request.getNoneAdditionKv().get("before_call_server_time") == null ? null : (Long)request.getNoneAdditionKv().get("before_call_server_time");
            Long serverExecCost = null;
            if (beforeCallServerTime != null && recvRespTime != null) {
                serverExecCost = recvRespTime - beforeCallServerTime;
            }
            LOGGER.info(requestLogFormat, new Object[]{beforeCallServerTime == null ? null : LogUtils.timestampToString(beforeCallServerTime), recvRespTime == null ? null : LogUtils.timestampToString(recvRespTime), request.getAttachmentKv().remove("provider_app_name"), request.getNoneAdditionKv().get("remote_address"), request.getProtocolName(), response.getStatus(), request.getNoneAdditionKv().get("client_request_cost"), LogUtils.simpleServiceName(request.getServiceName()), request.getMethodName(), encodeRequestBodyCost, request.getNoneAdditionKv().get("wait_for_io_thread_cost"), encodeRequestHeaderCost, serverExecCost, decodeResponseHeaderCost, waitForThreadCost, decodeResponseBodyCost, traceSpanIdMap.get(TCID), traceSpanIdMap.get(SPID)});
            LOGGER.debug("[REQLOG] Request logKv {}, Response logKv {}", request.getNoneAdditionKv(), response.getNoneAdditionKv());
        }
        catch (Exception e) {
            LOGGER.warn("Record server access log error, cause by {}", (Object)e.getMessage());
        }
    }

    public static void timeoutReqAdditionalLog(Response response) {
        try {
            String timeoutLog = "[TIMEOUT] Request {} timeout: {}. clientReqTime(approx) {}, servRecvTime {}, servCost(approx) {}, servMethodExecCost {}, recvTime {}, decRespHead {}, decRespBody {}, tid {}";
            String timeoutCause = null;
            Object methodExecCostObj = response.getAttachmentKv().get("execute_method_cost");
            Object reqTimeoutObj = response.getAttachmentKv().get("request_timeout");
            Object servCostObj = response.getAttachmentKv().get("serv_exec_cost");
            Integer requestTimeout = null;
            Long methodExecCost = null;
            Long serverCost = null;
            if (reqTimeoutObj instanceof Integer && methodExecCostObj instanceof Long) {
                requestTimeout = (Integer)reqTimeoutObj;
                methodExecCost = (Long)methodExecCostObj;
                if (methodExecCost >= (long)requestTimeout.intValue()) {
                    timeoutCause = "4801 Biz method execution timeout(" + methodExecCost + ">" + requestTimeout + "ms)";
                }
            }
            if (methodExecCostObj instanceof Long && servCostObj instanceof Long && StringUtils.isEmpty(timeoutCause)) {
                serverCost = (Long)servCostObj;
                methodExecCost = (Long)methodExecCostObj;
                if (serverCost - methodExecCost > 1000L) {
                    timeoutCause = "4802 Abnormal server instance status(CPU_WAIT_IO, tasks_used or cpu_used)";
                }
            }
            Object clientReqTimeObj = response.getAttachmentKv().get("before_encode_header_time");
            Object servRecvReqTimeObj = response.getAttachmentKv().get("serv_recv_req_time");
            Long clientReqTime = null;
            Long servRecvReqTime = null;
            if (clientReqTimeObj instanceof Long && servRecvReqTimeObj instanceof Long && StringUtils.isEmpty(timeoutCause)) {
                clientReqTime = (Long)clientReqTimeObj;
                servRecvReqTime = (Long)servRecvReqTimeObj;
                long messageDelay = servRecvReqTime - clientReqTime;
                if (messageDelay > 1000L) {
                    timeoutCause = "4803 Rpc message delay(" + messageDelay + "ms)";
                }
            }
            if (StringUtils.isEmpty(timeoutCause)) {
                timeoutCause = "4810 Unknown reason";
            }
            Object recvRespTime = response.getNoneAdditionKv().get("receive_byte_msg_time");
            Object traceId = response.getAttachmentKv().get("trace.id");
            LOGGER.error(timeoutLog, new Object[]{response.getNoneAdditionKv().get("remote_address"), timeoutCause, clientReqTimeObj instanceof Long ? LogUtils.timestampToString((Long)clientReqTimeObj) : null, servRecvReqTimeObj instanceof Long ? LogUtils.timestampToString((Long)servRecvReqTimeObj) : null, servCostObj, methodExecCostObj, recvRespTime instanceof Long ? LogUtils.timestampToString((Long)recvRespTime) : recvRespTime, response.getNoneAdditionKv().get("decode_header_cost"), response.getNoneAdditionKv().get("decode_body_cost"), traceId});
        }
        catch (Throwable e) {
            LOGGER.warn("Record server timeout log error, cause by ", e);
        }
    }

    public static String timestampToString(long timestamp) {
        Date date = new Date(timestamp);
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        return sdf.format(date);
    }

    protected static String simpleServiceName(String originServiceName) {
        if (!originServiceName.contains(".")) {
            return originServiceName;
        }
        String[] splitNames = originServiceName.split("\\.");
        if (splitNames.length == 1) {
            return originServiceName;
        }
        return splitNames[splitNames.length - 1];
    }

    public static Map<String, String> parseTraceIdSpanId(Request request) {
        Map<String, String> traceIdSpanIdMap = new HashMap<String, String>();
        if (request.getAttachmentKv() != null && request.getAttachmentKv().get(PROBE_SPAN_CONTEXT_KEY) instanceof String) {
            traceIdSpanIdMap = LogUtils.probeSpanContextToMap((String)request.getAttachmentKv().get(PROBE_SPAN_CONTEXT_KEY));
        }
        return traceIdSpanIdMap;
    }

    protected static Map<String, String> probeSpanContextToMap(String traceSpanContext) {
        String[] spanInfos;
        HashMap<String, String> traceSpanMap = new HashMap<String, String>();
        if (StringUtils.isBlank(traceSpanContext)) {
            return traceSpanMap;
        }
        if (traceSpanContext.endsWith(AND_CHARACTER)) {
            traceSpanContext = traceSpanContext.substring(0, traceSpanContext.length() - 1);
        }
        if (!traceSpanContext.contains(TCID) || !traceSpanContext.contains(SPID)) {
            return traceSpanMap;
        }
        String[] traceSpans = traceSpanContext.split(AND_CHARACTER);
        if (traceSpans.length < 2) {
            return traceSpanMap;
        }
        String[] traceInfos = traceSpans[0].split(EQUAL_CHARACTER);
        if (traceInfos.length == 2) {
            traceSpanMap.put(traceInfos[0], traceInfos[1]);
        }
        if ((spanInfos = traceSpans[1].split(EQUAL_CHARACTER)).length == 2) {
            traceSpanMap.put(spanInfos[0], spanInfos[1]);
        }
        return traceSpanMap;
    }
}

