/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.utils;

import com.baidu.cloud.starlight.api.utils.EnvUtils;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUriUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUriUtils.class);
    private static final Pattern KVP_PATTERN = Pattern.compile("([_.a-zA-Z0-9][-_.a-zA-Z0-9]*)[=](.*)");
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static InetAddress LOCAL_ADDRESS = null;
    private static String localHostIp = null;

    public static Map<String, String> parseQueryString(String qs) {
        if (qs == null || qs.length() == 0) {
            return new HashMap<String, String>();
        }
        return NetUriUtils.parseKeyValuePair(qs, "\\&");
    }

    private static Map<String, String> parseKeyValuePair(String str, String itemSeparator) {
        String[] tmp = str.split(itemSeparator);
        HashMap<String, String> map = new HashMap<String, String>(tmp.length);
        for (int i = 0; i < tmp.length; ++i) {
            Matcher matcher = KVP_PATTERN.matcher(tmp[i]);
            if (!matcher.matches()) continue;
            map.put(matcher.group(1), matcher.group(2));
        }
        return map;
    }

    public static String toQueryString(Map<String, String> ps) {
        StringBuilder buf = new StringBuilder();
        if (ps != null && ps.size() > 0) {
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(ps).entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || key.length() <= 0 || value == null || value.length() <= 0) continue;
                if (buf.length() > 0) {
                    buf.append("&");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
            }
        }
        return buf.toString();
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static synchronized String getLocalHost() {
        if (!StringUtils.isEmpty(localHostIp)) {
            return localHostIp;
        }
        if (EnvUtils.isJarvisEnv()) {
            if (!StringUtils.isEmpty(System.getenv("EM_IP"))) {
                localHostIp = System.getenv("EM_IP");
                return localHostIp;
            }
            if (!StringUtils.isEmpty(System.getenv("MATRIX_HOST_IP"))) {
                localHostIp = System.getenv("MATRIX_HOST_IP");
                return localHostIp;
            }
        }
        if (LOCAL_ADDRESS == null) {
            LOCAL_ADDRESS = NetUriUtils.getLocalAddress();
        }
        localHostIp = LOCAL_ADDRESS.getHostAddress();
        return localHostIp;
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (NetUriUtils.isValidAddress(localAddress)) {
                return localAddress;
            }
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface network = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = network.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (!NetUriUtils.isValidAddress(address)) continue;
                        return address;
                    }
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to retrieve ip address.", e);
        }
        LOGGER.error("Failed to get local host ip address, use 127.0.0.1 instead.");
        return localAddress;
    }

    public static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String addressName = address.getHostAddress();
        return addressName != null && !addressName.equals("0.0.0.0") && !addressName.equals("127.0.0.1") && IP_PATTERN.matcher(addressName).matches();
    }
}

