/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.filter;

import com.baidu.cloud.starlight.api.filter.Filter;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.rpc.Invoker;
import com.baidu.cloud.starlight.api.rpc.RpcContext;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContextFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerContextFilter.class);

    @Override
    public void filterRequest(Invoker invoker, Request request, RpcCallback callback) {
        try {
            Object remoteHost = request.getAttachmentKv().remove("remoteHost");
            Object remotePort = request.getAttachmentKv().remove("remotePort");
            RpcContext.getContext().setRemoteAddress(remoteHost instanceof String ? (String)remoteHost : null, remotePort instanceof Integer ? (Integer)remotePort : 0);
            RpcContext.getContext().set(request.getAttachmentKv());
            if (RpcContext.getContext().get("parameterTypes") != null) {
                RpcContext.getContext().remove("parameterTypes");
            }
            if (RpcContext.getContext().get("parmeters") != null) {
                RpcContext.getContext().remove("parmeters");
            }
            if (RpcContext.getContext().get("methodName") != null) {
                RpcContext.getContext().remove("methodName");
            }
            RpcContext.getContext().remove("consumer_app_name");
            RpcContext.getContext().remove("provider_app_name");
            RpcContext.getContext().remove("serialize_mode");
            RpcContext.getContext().remove("request_timeout");
            RpcContext.getContext().remove("before_encode_header_time");
            LOGGER.debug("Server RpcContext values in thread {} is {}", (Object)Thread.currentThread().getName(), RpcContext.getContext().get());
        }
        catch (Throwable e) {
            LOGGER.warn("Set Request Attachment to RpcContext failed, {}", (Object)e.getMessage());
        }
        invoker.invoke(request, callback);
    }

    @Override
    public void filterResponse(Response response, Request request) {
        RpcContext.removeContext();
    }
}

