/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.rpc;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.heartbeat.HeartbeatService;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.rpc.ClientInvoker;
import com.baidu.cloud.starlight.api.rpc.StarlightClient;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.rpc.config.TransportConfig;
import com.baidu.cloud.starlight.api.rpc.threadpool.ThreadPoolFactory;
import com.baidu.cloud.starlight.api.transport.ClientPeer;
import com.baidu.cloud.starlight.api.transport.PeerStatus;
import com.baidu.cloud.starlight.api.transport.TransportFactory;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.core.filter.FilterChain;
import com.baidu.cloud.starlight.core.rpc.ClientProcessor;
import com.baidu.cloud.starlight.core.rpc.RpcClientInvoker;
import com.baidu.cloud.starlight.core.statistics.StarlightStatsManager;
import com.baidu.cloud.starlight.protocol.brpc.BrpcProtocol;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleStarlightClient
implements StarlightClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleStarlightClient.class);
    private final URI uri;
    private final Map<String, ClientInvoker> clientInvokers;
    private ClientPeer clientPeer;
    private AtomicBoolean isInitialed = new AtomicBoolean(false);
    private static volatile ThreadPoolFactory threadPoolOfAll;

    public SingleStarlightClient(String remoteIp, Integer remotePort, TransportConfig transportConfig) {
        this.clientInvokers = new ConcurrentHashMap<String, ClientInvoker>();
        this.uri = this.assembleUri(remoteIp, remotePort, transportConfig);
        TransportFactory transportFactory = ExtensionLoader.getInstance(TransportFactory.class).getExtension("starlight");
        this.clientPeer = transportFactory.client(this.uri);
    }

    @Override
    public URI remoteURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void init() {
        if (threadPoolOfAll == null) {
            Class<SingleStarlightClient> clazz = SingleStarlightClient.class;
            // MONITORENTER : com.baidu.cloud.starlight.core.rpc.SingleStarlightClient.class
            if (threadPoolOfAll == null) {
                String bizThreadPoolName = this.uri.getParameter("biz_thread_pool_name");
                threadPoolOfAll = ExtensionLoader.getInstance(ThreadPoolFactory.class).getExtension(bizThreadPoolName);
                threadPoolOfAll.initDefaultThreadPool(this.uri, "star-c-biz");
            }
            // MONITOREXIT : clazz
        }
        if (!this.isInitialed.compareAndSet(false, true)) return;
        ClientProcessor processor = new ClientProcessor(threadPoolOfAll);
        this.clientPeer.setProcessor(processor);
        this.clientPeer.init();
        try {
            long startTime = System.currentTimeMillis();
            this.clientPeer.connect();
            LOGGER.debug("Connect to remote cost: {}", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            LOGGER.warn("Connect to remote {} failed when init the single client, cause by {}", (Object)this.uri.getAddress(), (Object)e.getMessage());
        }
        ServiceConfig serviceConfig = new ServiceConfig();
        serviceConfig.setFilters("");
        this.refer(HeartbeatService.class, serviceConfig);
        this.updateStatus(new PeerStatus(PeerStatus.Status.ACTIVE, System.currentTimeMillis()));
    }

    @Override
    public void refer(Class<?> serviceClass, ServiceConfig serviceConfig) {
        String serviceName;
        if (serviceClass.getInterfaces() != null && serviceClass.getInterfaces().length > 0) {
            if (serviceClass.getInterfaces().length > 1) {
                throw new StarlightRpcException("Starlight not support Multiple inheritance, Only supports one layer of inheritance");
            }
            serviceClass = serviceClass.getInterfaces()[0];
        }
        if (this.clientInvokers.get(serviceName = serviceConfig.serviceName(serviceClass)) != null) {
            return;
        }
        String filterNames = "clientcontext,clientmonitor";
        if (serviceConfig != null) {
            filterNames = serviceConfig.getFilters() == null ? filterNames : serviceConfig.getFilters();
        }
        ClientInvoker clientInvoker = FilterChain.buildClientChainInvoker(new RpcClientInvoker(this.clientPeer, serviceConfig), filterNames);
        this.clientInvokers.put(serviceName, clientInvoker);
    }

    @Override
    public void request(Request request, RpcCallback callback) {
        String protocolName;
        request.setRemoteURI(this.uri);
        if (!this.isActive() && !"com.baidu.cloud.starlight.api.heartbeat.HeartbeatService".equals(request.getServiceName())) {
            LOGGER.warn("Receive request when Client is inactive, status {}, request {}, remoteAddress {}", new Object[]{this.clientPeer.status(), request, this.uri.getHost() + ":" + this.uri.getPort()});
        }
        if (StringUtils.isBlank(protocolName = request.getProtocolName())) {
            ServiceConfig serviceConfig = request.getServiceConfig();
            protocolName = serviceConfig.getProtocol();
            request.setProtocolName(protocolName);
        }
        try {
            this.checkRequest(request);
        }
        catch (StarlightRpcException e) {
            callback.onError(e);
            return;
        }
        try {
            String serviceName = request.getServiceName();
            ClientInvoker clientInvoker = this.clientInvokers.get(serviceName);
            clientInvoker.invoke(request, callback);
        }
        catch (Exception e) {
            LOGGER.error("Unhandled exception was caught when request, request {}:{}", new Object[]{request.getServiceName(), request.getMethodName(), e});
            callback.onError(new StarlightRpcException(StarlightRpcException.UNKNOW, "Unhandled exception was caught when request, request " + request.getServiceName() + ":" + request.getMethodName() + ", cause by " + e.getMessage()));
        }
    }

    private void checkRequest(Request request) throws StarlightRpcException {
        String serviceName = request.getServiceName();
        ClientInvoker clientInvoker = this.clientInvokers.get(serviceName);
        if (clientInvoker == null) {
            throw new StarlightRpcException(StarlightRpcException.BAD_REQUEST, "The request service has not been refer, please call refer() before request, service {" + serviceName + "}");
        }
        String protocolName = request.getProtocolName();
        try {
            Protocol protocol = ExtensionLoader.getInstance(Protocol.class).getExtension(protocolName);
            if (protocol == null) {
                throw new StarlightRpcException(StarlightRpcException.BAD_REQUEST, "The protocol message in request is not support\uff0c protocolName {" + protocolName + "}");
            }
        }
        catch (Exception e) {
            if (e instanceof StarlightRpcException) {
                throw e;
            }
            throw new StarlightRpcException(StarlightRpcException.BAD_REQUEST, "The protocol message in request is illegal, protocolName {" + protocolName + "}", e);
        }
        if (protocolName.equals("brpc")) {
            BrpcProtocol.checkRequest(request);
        }
    }

    @Override
    public void destroy() {
        if (this.isInitialed.compareAndSet(true, false)) {
            StarlightStatsManager.removeStats(this.remoteURI());
            boolean gracefullyShutdown = this.uri.getParameter("gracefully_shutdown", Constants.GRACEFULLY_SHUTDOWN_ENABLE);
            if (this.clientPeer != null) {
                if (gracefullyShutdown) {
                    int quietPeriod = this.uri.getParameter("gracefully_shutdown_quiet_time", Constants.GRACEFULLY_SHUTDOWN_QUIET_PERIOD_VALUE);
                    int timeout = this.uri.getParameter("gracefully_shutdown_timeout", Constants.GRACEFULLY_SHUTDOWN_TIMEOUT_VALUE);
                    this.clientPeer.gracefullyShutdown(quietPeriod, timeout);
                } else {
                    this.clientPeer.close();
                }
            }
            if (this.clientInvokers.size() > 0) {
                this.clientInvokers.clear();
            }
        }
    }

    private URI assembleUri(String ip, Integer port, TransportConfig config) {
        URI.Builder uriBuilder = new URI.Builder("unspecified", ip, port);
        uriBuilder.param("connect_timeout", config.getConnectTimeoutMills() == null ? Constants.CONNECT_TIMEOUT_VALUE : config.getConnectTimeoutMills());
        uriBuilder.param("write_timeout", config.getWriteTimeoutMills() == null ? Constants.WRITE_TIMEOUT_VALUE : config.getWriteTimeoutMills());
        uriBuilder.param("request_timeout", config.getRequestTimeoutMills() == null ? Constants.REQUEST_TIMEOUT_VALUE : config.getRequestTimeoutMills());
        uriBuilder.param("read_idle_timeout", config.getReadIdleTimeout() == null ? 60 : config.getReadIdleTimeout());
        uriBuilder.param("io_thread_num", config.getIoThreadNum() == null ? Constants.DEFAULT_IO_THREADS_VALUE : config.getIoThreadNum());
        uriBuilder.param("max_heartbeat_times", config.getMaxHeartbeatTimes() == null ? 3 : config.getMaxHeartbeatTimes());
        uriBuilder.param("channel_type", config.getChannelType() == null ? "long" : config.getChannelType());
        uriBuilder.param("max_connections", config.getMaxConnections() == null ? Constants.MAX_TOTAL_CONNECTIONS : config.getMaxConnections());
        uriBuilder.param("max_idle_connections", config.getMaxIdleConnections() == null ? Constants.MAX_IDLE_CONNECTIONS : config.getMaxIdleConnections());
        uriBuilder.param("min_idle_connections", config.getMinIdleConnections() == null ? Constants.MIN_IDLE_CONNECTIONS : config.getMinIdleConnections());
        uriBuilder.param("gracefully_shutdown", config.getGracefullyShutdown() == null ? Constants.GRACEFULLY_SHUTDOWN_ENABLE : config.getGracefullyShutdown());
        uriBuilder.param("gracefully_shutdown_quiet_time", config.getGracefullyQuietPeriod() == null ? Constants.GRACEFULLY_SHUTDOWN_QUIET_PERIOD_VALUE : config.getGracefullyQuietPeriod());
        uriBuilder.param("gracefully_shutdown_timeout", config.getGracefullyTimeout() == null ? Constants.GRACEFULLY_SHUTDOWN_TIMEOUT_VALUE : config.getGracefullyTimeout());
        uriBuilder.param("connect_keepalive_enabled", config.getConnectKeepAliveEnable() == null ? false : config.getConnectKeepAliveEnable());
        uriBuilder.param("max_biz_work_num", config.getBizWorkThreadNum() == null ? Constants.DEFAULT_MAX_BIZ_THREAD_POOL_SIZE : config.getBizWorkThreadNum());
        uriBuilder.param("netty_ioratio", config.getIoRatio() == null ? 100 : config.getIoRatio());
        uriBuilder.param("biz_thread_pool_name", StringUtils.isEmpty(config.getBizThreadPoolName()) ? "rpc" : config.getBizThreadPoolName());
        if (config.getAdditional() != null) {
            uriBuilder.params(config.getAdditional());
        }
        return uriBuilder.build();
    }

    @Override
    public boolean isActive() {
        if (this.clientPeer == null) {
            return false;
        }
        if (this.clientPeer.status() == null) {
            return false;
        }
        return PeerStatus.Status.ACTIVE.equals((Object)this.clientPeer.status().getStatus());
    }

    @Override
    public PeerStatus getStatus() {
        return this.clientPeer.status();
    }

    @Override
    public void updateStatus(PeerStatus newStatus) {
        this.clientPeer.updateStatus(newStatus);
    }
}

