/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.rpc.callback;

import com.baidu.cloud.starlight.api.exception.RpcException;
import com.baidu.cloud.starlight.api.filter.Filter;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.model.RpcResponse;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.thirdparty.netty.util.Timeout;

public class FilterCallback
implements RpcCallback {
    private final Filter filter;
    private final RpcCallback callback;
    private final Request request;

    public FilterCallback(RpcCallback callback, Filter filter, Request request) {
        this.callback = callback;
        this.filter = filter;
        this.request = request;
    }

    @Override
    public void onResponse(Response response) {
        this.filter.filterResponse(response, this.request);
        if (this.callback != null) {
            this.callback.onResponse(response);
        }
    }

    @Override
    public void onError(Throwable e) {
        RpcResponse response = new RpcResponse(this.request.getId());
        ((Response)response).setErrorMsg(e.getMessage());
        if (e instanceof RpcException) {
            ((Response)response).setStatus(((RpcException)e).getCode());
        }
        this.filter.filterResponse(response, this.request);
        if (this.callback != null) {
            this.callback.onError(e);
        }
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void addTimeout(Timeout timeout) {
        this.callback.addTimeout(timeout);
    }
}

