/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.rpc.proxy;

import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.ResultFuture;
import com.baidu.cloud.starlight.api.model.RpcRequest;
import com.baidu.cloud.starlight.api.rpc.StarlightClient;
import com.baidu.cloud.starlight.api.rpc.callback.Callback;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.core.rpc.callback.BizWrapCallback;
import com.baidu.cloud.starlight.core.rpc.callback.FutureCallback;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.Future;

public class JdkInvocationHandler
implements InvocationHandler {
    private static final String FUTURE_SUFFIX = "Future";
    private static final String CALLBACK_SUFFIX = "Callback";
    private static final String ASYNC_INTERFACE_SUFFIX = "Async";
    private final StarlightClient client;
    private final Class<?> targetClass;
    private final ServiceConfig serviceConfig;

    JdkInvocationHandler(Class<?> targetClass, ServiceConfig serviceConfig, StarlightClient client) {
        this.client = client;
        this.targetClass = targetClass;
        this.serviceConfig = serviceConfig;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("equals".equals(method.getName()) && args.length == 1) {
            return this.equals(args[0]);
        }
        if ("hashCode".equals(method.getName()) && (args == null || args.length == 0)) {
            return this.hashCode();
        }
        if ("toString".equals(method.getName()) && (args == null || args.length == 0)) {
            return this.toString();
        }
        RpcCallback rpcCallback = null;
        Request request = null;
        Class<?> resultType = method.getReturnType();
        if (args != null && args.length > 1 && args[args.length - 1] instanceof Callback) {
            Callback bizCallBack = (Callback)args[args.length - 1];
            Object[] realArgs = Arrays.copyOf(args, args.length - 1);
            request = this.buildRequest(this.targetMethod(method), realArgs);
            rpcCallback = new BizWrapCallback(bizCallBack, request);
            this.client.request(request, rpcCallback);
            return null;
        }
        request = this.buildRequest(this.targetMethod(method), args);
        ResultFuture resultFuture = new ResultFuture();
        rpcCallback = new FutureCallback(resultFuture, request);
        this.client.request(request, rpcCallback);
        if (Future.class.isAssignableFrom(resultType)) {
            return resultFuture;
        }
        return resultFuture.get();
    }

    private Request buildRequest(Method method, Object[] realArgs) {
        RpcRequest request = new RpcRequest();
        ((Request)request).setServiceClass(this.targetServiceClass(this.targetClass));
        ((Request)request).setMethodName(method.getName());
        ((Request)request).setMethod(method);
        ((Request)request).setParamsTypes(method.getParameterTypes());
        ((Request)request).setGenericParamsTypes(method.getGenericParameterTypes());
        ((Request)request).setParams(realArgs);
        request.setReturnType(method.getReturnType());
        request.setGenericReturnType(method.getGenericReturnType());
        ((Request)request).setServiceConfig(this.serviceConfig);
        return request;
    }

    protected Method targetMethod(Method proxyMethod) {
        if (!this.isAsyncCall(proxyMethod)) {
            return proxyMethod;
        }
        Method targetMethod = null;
        Class<?>[] proxyParameterTypes = proxyMethod.getParameterTypes();
        Class<?> serviceClass = this.targetServiceClass(proxyMethod.getDeclaringClass());
        String methodName = proxyMethod.getName();
        if (methodName.endsWith(FUTURE_SUFFIX)) {
            try {
                targetMethod = serviceClass.getMethod(methodName.split(FUTURE_SUFFIX)[0], proxyParameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new StarlightRpcException("No related synchronization method in parent class, async method { " + methodName + "}, related sync method {" + methodName.split(FUTURE_SUFFIX)[0] + "}");
            }
        }
        if (methodName.endsWith(CALLBACK_SUFFIX)) {
            try {
                proxyParameterTypes = Arrays.copyOf(proxyParameterTypes, proxyParameterTypes.length - 1);
                targetMethod = serviceClass.getMethod(methodName.split(CALLBACK_SUFFIX)[0], proxyParameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new StarlightRpcException("No related synchronization method in parent class, async method { " + methodName + "}, related sync method {" + methodName.split(CALLBACK_SUFFIX)[0] + "}");
            }
        }
        return targetMethod;
    }

    protected Class<?> targetServiceClass(Class<?> proxyClass) {
        if (proxyClass.getInterfaces() != null && proxyClass.getInterfaces().length > 0) {
            if (proxyClass.getInterfaces().length > 1) {
                throw new StarlightRpcException("Starlight not support Multiple inheritance, Only supports one layer of inheritance when async call");
            }
            return proxyClass.getInterfaces()[0];
        }
        return proxyClass;
    }

    protected boolean isAsyncCall(Method proxyMethod) {
        if (this.targetClass.getInterfaces().length != 1) {
            return false;
        }
        if (!this.targetClass.getSimpleName().startsWith(ASYNC_INTERFACE_SUFFIX)) {
            return false;
        }
        String methodName = proxyMethod.getName();
        if (!methodName.endsWith(CALLBACK_SUFFIX) && !methodName.endsWith(FUTURE_SUFFIX)) {
            return false;
        }
        if (methodName.endsWith(CALLBACK_SUFFIX)) {
            Class<?>[] paramTypes = proxyMethod.getParameterTypes();
            if (paramTypes.length == 0) {
                return false;
            }
            return Callback.class.isAssignableFrom(paramTypes[paramTypes.length - 1]) && proxyMethod.getReturnType().equals(Void.TYPE);
        }
        return Future.class.isAssignableFrom(proxyMethod.getReturnType());
    }
}

