/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.rpc.threadpool;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.rpc.RpcService;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.rpc.threadpool.NamedThreadFactory;
import com.baidu.cloud.starlight.api.rpc.threadpool.ThreadPoolFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcThreadPoolFactory
implements ThreadPoolFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcThreadPoolFactory.class);
    private ThreadPoolExecutor defaultThreadPool;
    private final Map<RpcService, ThreadPoolExecutor> threadPoolMap = new ConcurrentHashMap<RpcService, ThreadPoolExecutor>();

    @Override
    public void initDefaultThreadPool(URI uri, String threadPrefix) {
        int maxPoolSize = uri.getParameter("max_biz_work_num", Constants.DEFAULT_MAX_BIZ_THREAD_POOL_SIZE);
        this.defaultThreadPool = new ThreadPoolExecutor((int)Constants.DEFAULT_BIZ_THREAD_POOL_SIZE, maxPoolSize, (long)Constants.IDlE_THREAD_KEEP_ALIVE_SECOND.intValue(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory(threadPrefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadPoolExecutor getThreadPool(RpcService rpcService) {
        if (rpcService == null) {
            return this.defaultThreadPool;
        }
        if (this.threadPoolMap.get(rpcService) != null) {
            return this.threadPoolMap.get(rpcService);
        }
        ServiceConfig serviceConfig = rpcService.getServiceConfig();
        if (serviceConfig == null) {
            return this.defaultThreadPool;
        }
        if (serviceConfig.getCustomizeThreadPool() == null || !serviceConfig.getCustomizeThreadPool().booleanValue()) {
            return this.defaultThreadPool;
        }
        Integer corePoolSize = serviceConfig.getThreadPoolSize();
        Integer maxThreadPoolSize = serviceConfig.getMaxThreadPoolSize();
        Integer keepAliveTime = serviceConfig.getIdleThreadKeepAliveSecond();
        Integer maxQueueSize = serviceConfig.getMaxRunnableQueueSize();
        try {
            ThreadPoolExecutor threadPool;
            RpcThreadPoolFactory rpcThreadPoolFactory = this;
            synchronized (rpcThreadPoolFactory) {
                if (this.threadPoolMap.get(rpcService) != null) {
                    return this.threadPoolMap.get(rpcService);
                }
                threadPool = new ThreadPoolExecutor((int)corePoolSize, (int)maxThreadPoolSize, (long)keepAliveTime.intValue(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxQueueSize), new NamedThreadFactory("service-biz-work"));
                this.threadPoolMap.put(rpcService, threadPool);
            }
            return threadPool;
        }
        catch (Exception e) {
            LOGGER.warn("Create service thread pool failed, will use default thread pool");
            return this.defaultThreadPool;
        }
    }

    @Override
    public ThreadPoolExecutor defaultThreadPool() {
        return this.defaultThreadPool;
    }

    @Override
    public void close() {
        for (ThreadPoolExecutor threadPool : this.threadPoolMap.values()) {
            if (threadPool.isShutdown()) continue;
            threadPool.shutdown();
        }
        this.threadPoolMap.clear();
        if (this.defaultThreadPool != null) {
            this.defaultThreadPool.shutdown();
        }
    }
}

