/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.statistics;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.statistics.CountStats;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedTimeWindowStats
implements CountStats {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedTimeWindowStats.class);
    private static final int COUNT_INIT_VALUE = 0;
    private long timeWindowSize;
    private final AtomicReference<StatsPair> statsPair;

    public FixedTimeWindowStats(long timeWindowSize) {
        this.timeWindowSize = timeWindowSize;
        this.statsPair = new AtomicReference<StatsPair>(new StatsPair());
    }

    @Override
    public Integer totalReqCount() {
        return this.recordAndGetReqCount(false, 0).getTotalReqCount();
    }

    @Override
    public Integer failReqCount() {
        return this.recordAndGetReqCount(false, 0).getFailReqCount();
    }

    @Override
    public Integer sucReqCount() {
        StatsPair pair = this.recordAndGetReqCount(false, 0);
        return pair.getTotalReqCount() - pair.getFailReqCount();
    }

    public void setTimeWindowSize(long timeWindowSize) {
        this.timeWindowSize = timeWindowSize;
    }

    @Override
    public void recordReqCount(boolean success) {
        this.recordAndGetReqCount(success, 1);
    }

    @Override
    public void record(Request request, Response response) {
        boolean success = true;
        if (!Constants.SUCCESS_CODE.equals(response.getStatus()) && response.getStatus() > 1000 && response.getStatus() < 3000) {
            success = false;
        }
        this.recordReqCount(success);
    }

    protected StatsPair recordAndGetReqCount(boolean success, int delta) {
        long startRecordTime = System.currentTimeMillis();
        StatsPair newPair = new StatsPair();
        StatsPair pair = null;
        do {
            pair = this.statsPair.get();
            long timeWinStartTime = pair.getTimeWinStartTime();
            newPair.setTimeWinStartTime(timeWinStartTime);
            long nextTimeWindStartTime = System.currentTimeMillis() - this.timeWindowSize * 1000L;
            if (nextTimeWindStartTime > timeWinStartTime) {
                LOGGER.debug("The current window started at {} is expire , will creat new window", (Object)timeWinStartTime);
                newPair.setTimeWinStartTime(System.currentTimeMillis());
                newPair.setTotalReqCount(0 + delta);
                newPair.setFailReqCount(0);
                if (success) continue;
                newPair.setFailReqCount(0 + delta);
                continue;
            }
            newPair.setTotalReqCount(pair.getTotalReqCount() + delta);
            newPair.setFailReqCount(pair.getFailReqCount());
            if (success) continue;
            newPair.setFailReqCount(pair.getFailReqCount() + delta);
        } while (!this.statsPair.compareAndSet(pair, newPair));
        LOGGER.debug("Get or record stats cost {}", (Object)(System.currentTimeMillis() - startRecordTime));
        return newPair;
    }

    private static class StatsPair {
        private Integer totalReqCount;
        private Integer failReqCount;
        private Long timeWinStartTime;

        public StatsPair() {
            this.totalReqCount = 0;
            this.failReqCount = 0;
            this.timeWinStartTime = System.currentTimeMillis();
        }

        public StatsPair(Integer totalReqCount, Integer failReqCount, Long timestamp) {
            this.totalReqCount = totalReqCount;
            this.failReqCount = failReqCount;
            this.timeWinStartTime = timestamp;
        }

        public Integer getTotalReqCount() {
            return this.totalReqCount;
        }

        public void setTotalReqCount(Integer totalReqCount) {
            this.totalReqCount = totalReqCount;
        }

        public Integer getFailReqCount() {
            return this.failReqCount;
        }

        public void setFailReqCount(Integer failReqCount) {
            this.failReqCount = failReqCount;
        }

        public Long getTimeWinStartTime() {
            return this.timeWinStartTime;
        }

        public void setTimeWinStartTime(Long timeWinStartTime) {
            this.timeWinStartTime = timeWinStartTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatsPair statsPair = (StatsPair)o;
            return Objects.equals(this.totalReqCount, statsPair.totalReqCount) && Objects.equals(this.failReqCount, statsPair.failReqCount) && Objects.equals(this.timeWinStartTime, statsPair.timeWinStartTime);
        }

        public int hashCode() {
            return Objects.hash(this.totalReqCount, this.failReqCount, this.timeWinStartTime);
        }
    }
}

