/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.statistics;

import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.statistics.Stats;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StarlightStatistics {
    private final Map<String, Stats> clientStatsMap = new ConcurrentHashMap<String, Stats>();

    public void record(Request request, Response response) {
        if (request == null || response == null) {
            return;
        }
        for (Map.Entry<String, Stats> clientStatsEntry : this.clientStatsMap.entrySet()) {
            if (clientStatsEntry.getValue() == null) continue;
            clientStatsEntry.getValue().record(request, response);
        }
    }

    public void registerStats(String statsKey, Stats stats) {
        this.clientStatsMap.putIfAbsent(statsKey, stats);
    }

    public Stats discoverStats(String statsKey) {
        return this.clientStatsMap.get(statsKey);
    }

    public Stats removeStats(String statsKey) {
        return this.clientStatsMap.remove(statsKey);
    }
}

