/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.brpc;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.AbstractMsgBase;
import com.baidu.cloud.starlight.api.model.MsgBase;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.model.RpcRequest;
import com.baidu.cloud.starlight.api.model.RpcResponse;
import com.baidu.cloud.starlight.api.model.Wrapper;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.protocol.ProtocolDecoder;
import com.baidu.cloud.starlight.api.serialization.serializer.Serializer;
import com.baidu.cloud.starlight.api.transport.buffer.DynamicCompositeByteBuf;
import com.baidu.cloud.starlight.api.utils.ByteArrayUtils;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.protocol.brpc.BrpcMeta;
import com.baidu.cloud.starlight.protocol.brpc.BrpcProtocol;
import com.baidu.cloud.starlight.protocol.brpc.BrpcRequestMeta;
import com.baidu.cloud.starlight.protocol.brpc.BrpcResponseMeta;
import com.baidu.cloud.starlight.protocol.brpc.CodeMapping;
import com.baidu.cloud.starlight.serialization.serializer.ProtoStuffSerializer;
import com.baidu.cloud.starlight.serialization.serializer.ProtobufSerializer;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBuf;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;

public class BrpcDecoder
implements ProtocolDecoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MsgBase decode(DynamicCompositeByteBuf input) throws CodecException {
        if (input.readableBytes() < 12) {
            throw new CodecException(CodecException.PROTOCOL_INSUFFICIENT_DATA_EXCEPTION, "Too little data to parse using Brpc");
        }
        ByteBuf fixHeaderBuf = input.retainedSlice(12);
        ByteBuf metaBuf = null;
        ByteBuf dataBuf = null;
        try {
            byte[] magic = new byte[4];
            fixHeaderBuf.readBytes(magic);
            if (!Arrays.equals(magic, BrpcProtocol.MAGIC_HEAD)) {
                throw new CodecException(CodecException.PROTOCOL_DECODE_NOTMATCH_EXCEPTION, "Magic num dose not match Brpc");
            }
            int bodySize = fixHeaderBuf.readInt();
            if (input.readableBytes() < 12 + bodySize) {
                throw new CodecException(CodecException.PROTOCOL_DECODE_NOTENOUGHDATA_EXCEPTION, "Data not enough to parse using Brpc");
            }
            if (bodySize > BrpcProtocol.MAX_BODY_SIZE) {
                throw new CodecException(CodecException.PROTOCOL_DECODE_EXCEPTION, "Data size is bigger than max_body_size(512M), the size is " + bodySize);
            }
            int metaSize = fixHeaderBuf.readInt();
            input.skipBytes(12);
            metaBuf = input.readRetainedSlice(metaSize);
            MsgBase output = this.decodeMeta(metaBuf);
            int dataSize = bodySize - metaSize;
            if (dataSize > 0) {
                dataBuf = input.readRetainedSlice(dataSize);
                if (dataBuf == null || dataBuf.readableBytes() == 0) {
                    throw new CodecException(CodecException.PROTOCOL_DECODE_EXCEPTION, "Brpc decode failed, brpc body data is null");
                }
                byte[] dataBytes = new byte[dataSize];
                dataBuf.readBytes(dataBytes);
                output.setBodyBytes(dataBytes);
            }
            output.setProtocolName("brpc");
            MsgBase msgBase = output;
            return msgBase;
        }
        finally {
            fixHeaderBuf.release();
            if (metaBuf != null) {
                metaBuf.release();
            }
            if (dataBuf != null) {
                dataBuf.release();
            }
        }
    }

    private MsgBase decodeMeta(ByteBuf metaBuf) throws CodecException {
        if (metaBuf == null || metaBuf.readableBytes() == 0) {
            throw new CodecException(CodecException.PROTOCOL_DECODE_EXCEPTION, "Brpc decode failed, brpc meta data is null");
        }
        AbstractMsgBase msgBase = null;
        try {
            int brpcMetaLength = metaBuf.readableBytes();
            byte[] brpcMetaArray = new byte[brpcMetaLength];
            metaBuf.readBytes(brpcMetaArray, 0, brpcMetaLength);
            ProtoStuffSerializer serializer = (ProtoStuffSerializer)this.serializer("protostuff");
            BrpcMeta rpcMeta = (BrpcMeta)serializer.deserialize(brpcMetaArray, (Type)((Object)BrpcMeta.class), BrpcProtocol.metaStrategyFlag(null));
            if (rpcMeta != null) {
                if (rpcMeta.getRequest() != null && !StringUtils.isEmpty(rpcMeta.getRequest().getServiceName())) {
                    msgBase = this.requestMeta(rpcMeta);
                }
                if (rpcMeta.getResponse() != null && rpcMeta.getResponse().getErrorCode() != null) {
                    msgBase = this.responseMeta(rpcMeta);
                }
                if (rpcMeta.getAttachmentSize() != null && rpcMeta.getAttachmentSize() > 0 && msgBase != null) {
                    if (msgBase.getAttachmentKv() == null) {
                        HashMap<String, Object> kvMap = new HashMap<String, Object>();
                        msgBase.setAttachmentKv(kvMap);
                    }
                    msgBase.getAttachmentKv().put("binary_attachment_size", rpcMeta.getAttachmentSize());
                }
            }
        }
        catch (Exception e) {
            throw new CodecException("Brpc decode metaBuf failed, deserialize meta error", e);
        }
        return msgBase;
    }

    private Request requestMeta(BrpcMeta rpcMeta) {
        RpcRequest request = new RpcRequest(rpcMeta.getCorrelationId());
        request.setCompressType(rpcMeta.getCompressType());
        request.setHeartbeat(false);
        request.setProtocolName("brpc");
        BrpcRequestMeta requestMeta = rpcMeta.getRequest();
        ((Request)request).setServiceName(requestMeta.getServiceName());
        ((Request)request).setMethodName(requestMeta.getMethodName());
        HashMap<String, Object> kvMap = new HashMap<String, Object>();
        if (rpcMeta.getAuthenticationData() != null && rpcMeta.getAuthenticationData().length > 0) {
            kvMap.put("auth_data", new String(rpcMeta.getAuthenticationData()));
        }
        kvMap.put("request.id", requestMeta.getLogId());
        kvMap.put("trace.id", requestMeta.getTraceId());
        kvMap.put("span.id", requestMeta.getSpanId());
        kvMap.put("parent.span.id", requestMeta.getParentSpanId());
        if (requestMeta.getExtFields() != null && requestMeta.getExtFields().size() > 0) {
            for (BrpcRequestMeta.BrpcRequestMetaExt extField : requestMeta.getExtFields()) {
                kvMap.put(extField.getKey(), extField.getValue());
            }
        }
        if (requestMeta.getStarlightRequestMeta() != null && requestMeta.getStarlightRequestMeta().getStarlightExtFields() != null) {
            kvMap.putAll(requestMeta.getStarlightRequestMeta().getStarlightExtFields());
        }
        request.setAttachmentKv(kvMap);
        return request;
    }

    private Response responseMeta(BrpcMeta rpcMeta) {
        RpcResponse response = new RpcResponse(rpcMeta.getCorrelationId());
        response.setCompressType(rpcMeta.getCompressType());
        BrpcResponseMeta responseMeta = rpcMeta.getResponse();
        ((Response)response).setStatus(CodeMapping.getStarlightMappingOfBrpcNo(responseMeta.getErrorCode()));
        ((Response)response).setErrorMsg(responseMeta.getErrorText());
        HashMap<String, Object> kvMap = new HashMap<String, Object>();
        kvMap.put("protocol", "brpc");
        response.setAttachmentKv(kvMap);
        if (responseMeta.getStarlightResponseMeta() != null) {
            kvMap.putAll(responseMeta.getStarlightResponseMeta().getStarlightExtFields());
        }
        return response;
    }

    @Override
    public void decodeBody(MsgBase msgBase) throws CodecException {
        if (msgBase == null) {
            throw new CodecException(CodecException.BODY_DECODE_EXCEPTION, "Message is null to decode");
        }
        if (msgBase.getBodyBytes() == null || msgBase.getBodyBytes().length == 0) {
            return;
        }
        int attachSize = 0;
        if (msgBase.getAttachmentKv() != null && msgBase.getAttachmentKv().get("binary_attachment_size") != null && (attachSize = ((Integer)msgBase.getAttachmentKv().get("binary_attachment_size")).intValue()) > 0) {
            byte[] dataBytes = ByteArrayUtils.subByte(msgBase.getBodyBytes(), 0, msgBase.getBodyBytes().length - attachSize);
            byte[] attach = ByteArrayUtils.subByte(msgBase.getBodyBytes(), msgBase.getBodyBytes().length - attachSize, attachSize);
            msgBase.setBodyBytes(dataBytes);
            msgBase.getAttachmentKv().put("binary_attachment", attach);
        }
        if (msgBase instanceof Request) {
            this.decodeRequestBody((Request)msgBase);
        }
        if (msgBase instanceof Response) {
            this.decodeResponseBody((Response)msgBase);
        }
    }

    private void decodeRequestBody(Request request) {
        Class<?>[] originParamTypes = request.getParamsTypes();
        BrpcProtocol.wrapReqParams(request);
        Serializer serializer = this.serializer(BrpcProtocol.bodySerType(request));
        Object object = null;
        if (serializer instanceof ProtoStuffSerializer) {
            ProtoStuffSerializer stuffSerializer = (ProtoStuffSerializer)serializer;
            Integer idStrategyFlag = BrpcProtocol.bodyStrategyFlag(BrpcProtocol.bodySerMode(request));
            object = stuffSerializer.deserialize(request.getBodyBytes(), request.getParamsTypes()[0], idStrategyFlag);
        }
        if (serializer instanceof ProtobufSerializer) {
            ProtobufSerializer protobufSerializer = (ProtobufSerializer)serializer;
            object = protobufSerializer.deserialize(request.getBodyBytes(), request.getParamsTypes()[0]);
        }
        request.setParams(new Object[]{object});
        if (object instanceof Wrapper) {
            request.setParams((Object[])((Wrapper)object).getObj());
        }
        request.setParamsTypes(originParamTypes);
    }

    private void decodeResponseBody(Response response) {
        Class<?> originRetType = response.getReturnType();
        BrpcProtocol.wrapRespResult(response);
        Serializer serializer = this.serializer(BrpcProtocol.bodySerType(response.getRequest()));
        Object result = null;
        if (serializer instanceof ProtoStuffSerializer) {
            ProtoStuffSerializer stuffSerializer = (ProtoStuffSerializer)serializer;
            Integer idStrategyFlag = BrpcProtocol.bodyStrategyFlag(BrpcProtocol.bodySerMode(response.getRequest()));
            result = stuffSerializer.deserialize(response.getBodyBytes(), response.getReturnType(), idStrategyFlag);
        }
        if (serializer instanceof ProtobufSerializer) {
            ProtobufSerializer protobufSerializer = (ProtobufSerializer)serializer;
            result = protobufSerializer.deserialize(response.getBodyBytes(), response.getReturnType());
        }
        response.setResult(result);
        if (result instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)result;
            response.setResult(wrapper.getObj());
        }
        response.setReturnType(originRetType);
    }

    private Serializer serializer(String serializerType) {
        BrpcProtocol brpcProtocol = (BrpcProtocol)ExtensionLoader.getInstance(Protocol.class).getExtension("brpc");
        return brpcProtocol.getSerialize(serializerType);
    }
}

