/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.brpc;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.thirdparty.google.common.collect.BiMap;
import com.baidu.cloud.thirdparty.google.common.collect.HashBiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeMapping {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeMapping.class);
    public static final Integer ENOSERVICE = 1001;
    public static final Integer ENOMETHOD = 1002;
    public static final Integer EREQUEST = 1003;
    public static final Integer EAUTH = 1004;
    public static final Integer ETOOMANYFAILS = 1005;
    public static final Integer EPCHANFINISH = 1006;
    public static final Integer EBACKUPREQUEST = 1007;
    public static final Integer ERPCTIMEDOUT = 1008;
    public static final Integer EFAILEDSOCKET = 1009;
    public static final Integer EHTTP = 1010;
    public static final Integer EOVERCROWDED = 1011;
    public static final Integer ERTMPPUBLISHABLE = 1012;
    public static final Integer ERTMPCREATESTREAM = 1013;
    public static final Integer EEOF = 1014;
    public static final Integer EUNUSED = 1015;
    public static final Integer ESSL = 1016;
    public static final Integer EINTERNAL = 2001;
    public static final Integer ERESPONSE = 2002;
    public static final Integer ELOGOFF = 2003;
    public static final Integer ELIMIT = 2004;
    public static final Integer ECLOSE = 2005;
    public static final Integer EITP = 2006;
    private static final BiMap<Integer, Integer> starlightToBrpcCodeMap = HashBiMap.create();

    public static Integer getBrpcMappingOfStarlightNo(Integer starlightNo) {
        if (starlightNo.equals(Constants.SUCCESS_CODE)) {
            return 0;
        }
        Integer mappingNo = (Integer)starlightToBrpcCodeMap.get((Object)starlightNo);
        if (mappingNo != null) {
            return mappingNo;
        }
        if (starlightNo >= TransportException.CONNECT_EXCEPTION) {
            return EFAILEDSOCKET;
        }
        return EINTERNAL;
    }

    public static Integer getStarlightMappingOfBrpcNo(Integer brpcNo) {
        if (brpcNo.equals(0)) {
            return Constants.SUCCESS_CODE;
        }
        if (brpcNo.equals(Constants.SUCCESS_CODE)) {
            LOGGER.warn("The brpc return code is 200, please make sure this is correct. Maybe use an old version in sever(less than 2020.0.1-SNAPSHOT)");
            return Constants.SUCCESS_CODE;
        }
        Integer mappingNo = (Integer)starlightToBrpcCodeMap.inverse().get((Object)brpcNo);
        if (mappingNo != null) {
            return mappingNo;
        }
        return StarlightRpcException.INTERNAL_SERVER_ERROR;
    }

    static {
        starlightToBrpcCodeMap.put((Object)StarlightRpcException.BAD_REQUEST, (Object)EREQUEST);
        starlightToBrpcCodeMap.put((Object)StarlightRpcException.SERVICE_NOT_FOUND_EXCEPTION, (Object)ENOSERVICE);
        starlightToBrpcCodeMap.put((Object)StarlightRpcException.METHOD_NOT_FOUND_EXCEPTION, (Object)ENOMETHOD);
        starlightToBrpcCodeMap.put((Object)StarlightRpcException.INTERNAL_SERVER_ERROR, (Object)EINTERNAL);
        starlightToBrpcCodeMap.put((Object)StarlightRpcException.TIME_OUT_EXCEPTION, (Object)ERPCTIMEDOUT);
    }
}

