/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.http.springrest;

import com.baidu.cloud.starlight.protocol.http.springrest.ByteBufServletOutputStream;
import com.baidu.cloud.starlight.protocol.http.springrest.NettyServletRequestAdaptor;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBufOutputStream;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.FullHttpResponse;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaderNames;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpResponseStatus;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.cookie.DefaultCookie;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.cookie.ServerCookieEncoder;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.ServletOutputStream;
import com.baidu.cloud.thirdparty.servlet.http.Cookie;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;

public class NettyServletResponseAdaptor
implements HttpServletResponse {
    private NettyServletRequestAdaptor servletRequest;
    private FullHttpResponse nettyHttpResponse;
    private ByteBufServletOutputStream outputStream;
    private Locale locale;
    private boolean commited;
    private PrintWriter writer;

    public NettyServletResponseAdaptor(FullHttpResponse nettyHttpResponse, NettyServletRequestAdaptor servletRequest) {
        this(nettyHttpResponse);
        this.servletRequest = servletRequest;
    }

    public NettyServletResponseAdaptor(FullHttpResponse nettyResponse) {
        this.nettyHttpResponse = nettyResponse;
        this.outputStream = new ByteBufServletOutputStream(new ByteBufOutputStream(nettyResponse.content()));
        this.writer = new PrintWriter((OutputStream)((Object)this.outputStream));
        this.locale = Locale.getDefault();
    }

    public void addCookie(Cookie cookie) {
        DefaultCookie nettyCookie = new DefaultCookie(cookie.getName(), cookie.getValue());
        nettyCookie.setDomain(cookie.getDomain());
        nettyCookie.setMaxAge((long)cookie.getMaxAge());
        nettyCookie.setPath(cookie.getPath());
        nettyCookie.setHttpOnly(cookie.isHttpOnly());
        nettyCookie.setSecure(cookie.getSecure());
        String cookResult = ServerCookieEncoder.LAX.encode((com.baidu.cloud.thirdparty.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        this.nettyHttpResponse.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)cookResult);
    }

    public boolean containsHeader(String headerKey) {
        return this.nettyHttpResponse.headers().contains(headerKey);
    }

    public String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException((Throwable)new ServletException("Encoder URL failed", (Throwable)e));
        }
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeURL(url);
    }

    public void sendError(int code, String msg) throws IOException {
        if (msg != null) {
            msg = msg.replace("\r", " ");
            msg = msg.replace("\n", " ");
        }
        this.nettyHttpResponse.setStatus(new HttpResponseStatus(code, msg));
    }

    public void sendError(int status) throws IOException {
        this.nettyHttpResponse.setStatus(HttpResponseStatus.valueOf((int)status));
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setHeader(HttpHeaderNames.LOCATION.toString(), location);
    }

    public void setDateHeader(String name, long date) {
        this.nettyHttpResponse.headers().set(name, (Object)date);
    }

    public void addDateHeader(String name, long date) {
        this.nettyHttpResponse.headers().add(name, (Object)date);
    }

    public void setHeader(String name, String value) {
        this.nettyHttpResponse.headers().set(name, (Object)value);
    }

    public void addHeader(String name, String value) {
        this.nettyHttpResponse.headers().add(name, (Object)value);
    }

    public void setIntHeader(String name, int value) {
        this.nettyHttpResponse.headers().setInt((CharSequence)name, value);
    }

    public void addIntHeader(String name, int value) {
        this.nettyHttpResponse.headers().addInt((CharSequence)name, value);
    }

    public void setStatus(int status) {
        this.nettyHttpResponse.setStatus(HttpResponseStatus.valueOf((int)status));
    }

    public void setStatus(int status, String msg) {
        this.nettyHttpResponse.setStatus(new HttpResponseStatus(status, msg));
    }

    public int getStatus() {
        return this.nettyHttpResponse.status().code();
    }

    public String getHeader(String name) {
        return this.nettyHttpResponse.headers().get(name);
    }

    public Collection<String> getHeaders(String name) {
        return Arrays.asList(this.nettyHttpResponse.headers().get(name));
    }

    public Collection<String> getHeaderNames() {
        return this.nettyHttpResponse.headers().names();
    }

    public String getCharacterEncoding() {
        String charset = this.nettyHttpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        return charset != null ? charset : "utf-8";
    }

    public String getContentType() {
        return this.nettyHttpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public void setCharacterEncoding(String charset) {
        this.nettyHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)charset);
    }

    public void setContentLength(int contentLength) {
        this.nettyHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)contentLength);
    }

    public void setContentLengthLong(long contentLengthLong) {
        this.nettyHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)contentLengthLong);
    }

    public void setContentType(String contentType) {
        this.nettyHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
    }

    public void setBufferSize(int bufferSize) {
    }

    public int getBufferSize() {
        return this.outputStream.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.getWriter().flush();
        this.commited = true;
    }

    public void resetBuffer() {
        this.outputStream.resetBuffer();
    }

    public boolean isCommitted() {
        return this.commited;
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed!");
        }
        this.nettyHttpResponse.headers().clear();
        this.resetBuffer();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public FullHttpResponse getNettyHttpResponse() {
        return this.nettyHttpResponse;
    }

    public void setNettyHttpResponse(FullHttpResponse nettyHttpResponse) {
        this.nettyHttpResponse = nettyHttpResponse;
    }

    public NettyServletRequestAdaptor getServletRequest() {
        return this.servletRequest;
    }

    public void setServletRequest(NettyServletRequestAdaptor servletRequest) {
        this.servletRequest = servletRequest;
    }
}

