/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.http.springrest;

import com.baidu.cloud.thirdparty.feign.MethodMetadata;
import com.baidu.cloud.thirdparty.feign.Param;
import com.baidu.cloud.thirdparty.feign.QueryMapEncoder;
import com.baidu.cloud.thirdparty.feign.RequestTemplate;
import com.baidu.cloud.thirdparty.feign.Target;
import com.baidu.cloud.thirdparty.feign.Util;
import com.baidu.cloud.thirdparty.feign.codec.EncodeException;
import com.baidu.cloud.thirdparty.feign.template.UriUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RequestTemplateArgsResolver {
    private final QueryMapEncoder queryMapEncoder;
    protected final Target<?> target;

    public RequestTemplateArgsResolver(QueryMapEncoder queryMapEncoder, Target<?> target) {
        this.target = target;
        this.queryMapEncoder = queryMapEncoder;
    }

    public RequestTemplate create(Object[] argv, MethodMetadata metadata) {
        RequestTemplate mutable = RequestTemplate.from((RequestTemplate)metadata.template());
        mutable.feignTarget(this.target);
        if (metadata.urlIndex() != null) {
            int urlIndex = metadata.urlIndex();
            Util.checkArgument((argv[urlIndex] != null ? 1 : 0) != 0, (String)"URI parameter %s was null", (Object[])new Object[]{urlIndex});
            mutable.target(String.valueOf(argv[urlIndex]));
        }
        Map<Integer, Param.Expander> indexToExpander = this.indexToExpander(metadata);
        LinkedHashMap<String, Object> varBuilder = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : metadata.indexToName().entrySet()) {
            int i = (Integer)entry.getKey();
            Object value = argv[(Integer)entry.getKey()];
            if (value == null) continue;
            if (indexToExpander.containsKey(i)) {
                value = this.expandElements(indexToExpander.get(i), value);
            }
            for (String name : (Collection)entry.getValue()) {
                varBuilder.put(name, value);
            }
        }
        RequestTemplate template = this.resolve(argv, mutable, varBuilder, metadata);
        if (metadata.queryMapIndex() != null) {
            Object value = argv[metadata.queryMapIndex()];
            Map<String, Object> queryMap = this.toQueryMap(value);
            template = this.addQueryMapQueryParameters(queryMap, template, metadata);
        }
        if (metadata.headerMapIndex() != null) {
            template = this.addHeaderMapHeaders((Map)argv[metadata.headerMapIndex()], template);
        }
        return template;
    }

    private Map<Integer, Param.Expander> indexToExpander(MethodMetadata metadata) {
        LinkedHashMap<Integer, Param.Expander> indexToExpander = new LinkedHashMap<Integer, Param.Expander>();
        if (metadata.indexToExpander() != null) {
            indexToExpander.putAll(metadata.indexToExpander());
            return indexToExpander;
        }
        if (metadata.indexToExpanderClass().isEmpty()) {
            return indexToExpander;
        }
        for (Map.Entry indexToExpanderClass : metadata.indexToExpanderClass().entrySet()) {
            try {
                indexToExpander.put((Integer)indexToExpanderClass.getKey(), (Param.Expander)((Class)indexToExpanderClass.getValue()).newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return indexToExpander;
    }

    private Map<String, Object> toQueryMap(Object value) {
        if (value instanceof Map) {
            return (Map)value;
        }
        try {
            return this.queryMapEncoder.encode(value);
        }
        catch (EncodeException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object expandElements(Param.Expander expander, Object value) {
        if (value instanceof Iterable) {
            return this.expandIterable(expander, (Iterable)value);
        }
        return expander.expand(value);
    }

    private List<String> expandIterable(Param.Expander expander, Iterable value) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object element : value) {
            if (element == null) continue;
            values.add(expander.expand(element));
        }
        return values;
    }

    private RequestTemplate addHeaderMapHeaders(Map<String, Object> headerMap, RequestTemplate mutable) {
        for (Map.Entry<String, Object> currEntry : headerMap.entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            Object currValue = currEntry.getValue();
            if (currValue instanceof Iterable) {
                for (Object nextObject : (Iterable)currValue) {
                    values.add(nextObject == null ? null : nextObject.toString());
                }
            } else {
                values.add(currValue == null ? null : currValue.toString());
            }
            mutable.header(currEntry.getKey(), values);
        }
        return mutable;
    }

    private RequestTemplate addQueryMapQueryParameters(Map<String, Object> queryMap, RequestTemplate mutable, MethodMetadata metadata) {
        for (Map.Entry<String, Object> currEntry : queryMap.entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            boolean encoded = metadata.queryMapEncoded();
            Object currValue = currEntry.getValue();
            if (currValue instanceof Iterable) {
                for (Object nextObject : (Iterable)currValue) {
                    if (nextObject == null) {
                        values.add(null);
                        continue;
                    }
                    values.add(encoded ? nextObject.toString() : UriUtils.encode((String)nextObject.toString()));
                }
            } else if (currValue == null) {
                values.add(null);
            } else {
                values.add(encoded ? currValue.toString() : UriUtils.encode((String)currValue.toString()));
            }
            mutable.query(encoded ? currEntry.getKey() : UriUtils.encode((String)currEntry.getKey()), values);
        }
        return mutable;
    }

    protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables, MethodMetadata methodMetadata) {
        return mutable.resolve(variables);
    }
}

