/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.http.springrest;

import com.baidu.cloud.starlight.protocol.http.springrest.BytesHttpMessageConverter;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.aop.support.AopUtils;
import com.baidu.cloud.thirdparty.springframework.core.DefaultParameterNameDiscoverer;
import com.baidu.cloud.thirdparty.springframework.core.MethodIntrospector;
import com.baidu.cloud.thirdparty.springframework.core.MethodParameter;
import com.baidu.cloud.thirdparty.springframework.core.ParameterNameDiscoverer;
import com.baidu.cloud.thirdparty.springframework.http.converter.StringHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import com.baidu.cloud.thirdparty.springframework.web.bind.support.DefaultDataBinderFactory;
import com.baidu.cloud.thirdparty.springframework.web.bind.support.WebDataBinderFactory;
import com.baidu.cloud.thirdparty.springframework.web.context.request.NativeWebRequest;
import com.baidu.cloud.thirdparty.springframework.web.context.request.ServletWebRequest;
import com.baidu.cloud.thirdparty.springframework.web.method.HandlerMethod;
import com.baidu.cloud.thirdparty.springframework.web.method.annotation.ExpressionValueMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.annotation.RequestHeaderMapMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.annotation.RequestHeaderMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.annotation.RequestParamMapMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.support.HandlerMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.RequestMappingInfo;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.MatrixVariableMapMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.MatrixVariableMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.PathVariableMapMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.PathVariableMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.RequestAttributeMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.RequestPartMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.ServletCookieValueMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.ServletRequestMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.ServletResponseMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.SessionAttributeMethodArgumentResolver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringRestHandlerMapping
extends RequestMappingHandlerMapping {
    private static Logger logger = LoggerFactory.getLogger(SpringRestHandlerMapping.class);
    private static SpringRestHandlerMapping requestMappingHandlerMapping;
    private static final HandlerMethodArgumentResolverComposite argumentResolvers;
    private static final ParameterNameDiscoverer parameterNameDiscoverer;
    private static final WebDataBinderFactory dataBinderFactory;

    private SpringRestHandlerMapping() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpringRestHandlerMapping getInstance() {
        Class<SpringRestHandlerMapping> clazz = SpringRestHandlerMapping.class;
        synchronized (SpringRestHandlerMapping.class) {
            if (requestMappingHandlerMapping == null) {
                requestMappingHandlerMapping = new SpringRestHandlerMapping();
                argumentResolvers.addResolvers(SpringRestHandlerMapping.getDefaultArgumentResolvers());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return requestMappingHandlerMapping;
        }
    }

    public void createMapping(Class serviceType, Object serviceObj) {
        if (serviceType != null) {
            Class userType = ClassUtils.getUserClass((Class)serviceType);
            Map methods = MethodIntrospector.selectMethods((Class)userType, method -> {
                try {
                    return this.getMappingForMethod(method, userType);
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Invalid mapping on handler class [" + userType.getName() + "]: " + method, ex);
                }
            });
            logger.debug(methods.size() + " request handler methods found on " + userType + ": " + methods);
            methods.forEach((method, mapping) -> {
                Method invocableMethod = AopUtils.selectInvocableMethod((Method)method, (Class)userType);
                this.registerHandlerMethod(serviceObj, invocableMethod, mapping);
            });
        }
    }

    public HandlerMethod handler(HttpServletRequest request) throws Exception {
        return this.getHandlerInternal(request);
    }

    public Object[] resolveArguments(HandlerMethod method, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletWebRequest webRequest = new ServletWebRequest(request, response);
        return this.getMethodArgumentValues((NativeWebRequest)webRequest, method);
    }

    private Object[] getMethodArgumentValues(NativeWebRequest request, HandlerMethod method) throws Exception {
        MethodParameter[] parameters = method.getMethodParameters();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter parameter = parameters[i];
            parameter.initParameterNameDiscovery(parameterNameDiscoverer);
            if (argumentResolvers.supportsParameter(parameter)) {
                try {
                    args[i] = argumentResolvers.resolveArgument(parameter, null, request, dataBinderFactory);
                    continue;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed to resolve", (Throwable)ex);
                    }
                    throw ex;
                }
            }
            if (args[i] != null) continue;
            throw new IllegalStateException("Could not resolve method parameter at index " + parameter.getParameterIndex() + " in " + parameter.getExecutable().toGenericString() + ": No suitable resolver for");
        }
        return args;
    }

    private static List<HandlerMethodArgumentResolver> getDefaultArgumentResolvers() {
        ArrayList<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
        resolvers.add((HandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(null, false));
        resolvers.add((HandlerMethodArgumentResolver)new RequestParamMapMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new PathVariableMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new PathVariableMapMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new MatrixVariableMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new MatrixVariableMapMethodArgumentResolver());
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        ArrayList<BytesHttpMessageConverter> messageConverters = new ArrayList<BytesHttpMessageConverter>(2);
        messageConverters.add(new BytesHttpMessageConverter());
        messageConverters.add((BytesHttpMessageConverter)stringHttpMessageConverter);
        resolvers.add((HandlerMethodArgumentResolver)new RequestResponseBodyMethodProcessor(messageConverters));
        resolvers.add((HandlerMethodArgumentResolver)new RequestPartMethodArgumentResolver(messageConverters));
        resolvers.add((HandlerMethodArgumentResolver)new RequestHeaderMethodArgumentResolver(null));
        resolvers.add((HandlerMethodArgumentResolver)new RequestHeaderMapMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new ServletCookieValueMethodArgumentResolver(null));
        resolvers.add((HandlerMethodArgumentResolver)new ExpressionValueMethodArgumentResolver(null));
        resolvers.add((HandlerMethodArgumentResolver)new SessionAttributeMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new RequestAttributeMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new ServletRequestMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new ServletResponseMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(null, true));
        return resolvers;
    }

    public RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        Map requestMappingInfoHandlerMethodMap = this.getHandlerMethods();
        for (Map.Entry entry : requestMappingInfoHandlerMethodMap.entrySet()) {
            if (!((HandlerMethod)entry.getValue()).getMethod().equals(method)) continue;
            return (RequestMappingInfo)entry.getKey();
        }
        return super.getMappingForMethod(method, handlerType);
    }

    static {
        argumentResolvers = new HandlerMethodArgumentResolverComposite();
        parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
        dataBinderFactory = new DefaultDataBinderFactory(null);
    }
}

