/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.http.springrest;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.utils.GenericUtil;
import com.baidu.cloud.starlight.protocol.http.HttpEncoder;
import com.baidu.cloud.starlight.protocol.http.springrest.EncodedRequestTemplateArgsResolver;
import com.baidu.cloud.starlight.protocol.http.springrest.NettyServletRequestAdaptor;
import com.baidu.cloud.starlight.protocol.http.springrest.RequestTemplateArgsResolver;
import com.baidu.cloud.starlight.protocol.http.springrest.RequestTemplateGenerator;
import com.baidu.cloud.starlight.protocol.http.springrest.SpringRestHandlerMapping;
import com.baidu.cloud.thirdparty.feign.Feign;
import com.baidu.cloud.thirdparty.feign.MethodMetadata;
import com.baidu.cloud.thirdparty.feign.QueryMapEncoder;
import com.baidu.cloud.thirdparty.feign.RequestTemplate;
import com.baidu.cloud.thirdparty.feign.Target;
import com.baidu.cloud.thirdparty.feign.querymap.FieldQueryMapEncoder;
import com.baidu.cloud.thirdparty.feign.spring.SpringContract;
import com.baidu.cloud.thirdparty.netty.buffer.Unpooled;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.DefaultFullHttpRequest;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.FullHttpRequest;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.FullHttpResponse;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaderNames;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaderValues;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpMethod;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpVersion;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.http.MediaType;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.MediaTypeExpression;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.RequestMappingInfo;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SpringRestHttpEncoder
extends HttpEncoder {
    private static final SpringContract contract = new SpringContract();
    private final Map<String, RequestTemplateGenerator> requestTemplateGeneratorCache = new ConcurrentHashMap<String, RequestTemplateGenerator>();
    private final Map<Class<?>, String> parsedServiceClass = new ConcurrentHashMap();

    @Override
    protected FullHttpRequest convertRequest(Request rpcRequest) {
        Method targetMethod;
        RequestTemplateGenerator generator;
        if (GenericUtil.isGenericCall(rpcRequest)) {
            throw new StarlightRpcException(StarlightRpcException.BAD_REQUEST, "SpringRest protocol not support generic call");
        }
        Class<?> serviceClass = rpcRequest.getServiceClass();
        if (this.parsedServiceClass.get(serviceClass) == null) {
            this.parseAndValidateMeta(serviceClass);
        }
        if ((generator = this.requestTemplateGeneratorCache.get(Feign.configKey(serviceClass, (Method)(targetMethod = rpcRequest.getMethod())))) == null) {
            throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "Encode request with SpringRestProtocol failed: can not find parsed methodMeta, maybe the method {" + targetMethod.getName() + "} is illegal");
        }
        RequestTemplate template = generator.create(rpcRequest.getParams());
        return this.convert(template, rpcRequest);
    }

    private void parseAndValidateMeta(Class<?> serviceClass) {
        List methodMetadatas = contract.parseAndValidateMetadata(serviceClass);
        Protocol protocol = ExtensionLoader.getInstance(Protocol.class).getExtension("springrest");
        for (MethodMetadata metadata : methodMetadatas) {
            RequestTemplateGenerator generator = null;
            generator = metadata.bodyIndex() != null ? new RequestTemplateGenerator(metadata, new EncodedRequestTemplateArgsResolver((QueryMapEncoder)new FieldQueryMapEncoder(), (Target)Target.EmptyTarget.create(serviceClass), protocol.getSerialize())) : new RequestTemplateGenerator(metadata, new RequestTemplateArgsResolver((QueryMapEncoder)new FieldQueryMapEncoder(), (Target<?>)Target.EmptyTarget.create(serviceClass)));
            this.requestTemplateGeneratorCache.put(metadata.configKey(), generator);
        }
        this.parsedServiceClass.put(serviceClass, serviceClass.getSimpleName());
    }

    private FullHttpRequest convert(RequestTemplate requestTemplate, Request request) {
        com.baidu.cloud.thirdparty.feign.Request feignRequest = requestTemplate.request();
        DefaultFullHttpRequest httpRequest = null;
        if (feignRequest.body() != null && feignRequest.body().length > 0) {
            httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)feignRequest.httpMethod().name()), feignRequest.url(), Unpooled.wrappedBuffer((byte[])feignRequest.body()));
            httpRequest.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json;UTF-8");
            httpRequest.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)feignRequest.body().length);
        } else {
            httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)feignRequest.httpMethod().name()), feignRequest.url());
        }
        httpRequest.headers().add("x-starlight-id", (Object)request.getId());
        httpRequest.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        if (request.getAttachmentKv() != null) {
            for (Map.Entry<String, Object> entry : request.getAttachmentKv().entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                httpRequest.headers().add(entry.getKey(), entry.getValue());
            }
        }
        if (feignRequest.headers().size() > 0) {
            for (Map.Entry<String, Object> entry : feignRequest.headers().entrySet()) {
                httpRequest.headers().add(entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return httpRequest;
    }

    @Override
    protected FullHttpResponse convertResponse(Response response) {
        return super.convertResponse(response);
    }

    @Override
    protected void fulfillRpcResponse(FullHttpResponse httpResponse, Response response) {
        NettyServletRequestAdaptor servletRequestAdaptor = (NettyServletRequestAdaptor)response.getRequest().getAttachmentKv().remove("http_servlet_request");
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.contentType(servletRequestAdaptor, response));
        super.fulfillRpcResponse(httpResponse, response);
    }

    private String contentType(NettyServletRequestAdaptor servletRequestAdaptor, Response response) {
        SpringRestHandlerMapping handlerMapping = SpringRestHandlerMapping.getInstance();
        if (response.getRequest().getMethod() == null) {
            return HttpHeaderValues.APPLICATION_JSON.toString();
        }
        RequestMappingInfo requestMappingInfo = handlerMapping.getMappingForMethod(response.getRequest().getMethod(), response.getRequest().getMethod().getDeclaringClass());
        if (requestMappingInfo == null) {
            return HttpHeaderValues.APPLICATION_JSON.toString();
        }
        ProducesRequestCondition producesRequestCondition = requestMappingInfo.getProducesCondition().getMatchingCondition((HttpServletRequest)servletRequestAdaptor);
        if (producesRequestCondition != null && producesRequestCondition.getExpressions().size() > 0) {
            MediaType contentMediaType = ((MediaTypeExpression)producesRequestCondition.getExpressions().iterator().next()).getMediaType();
            return contentMediaType.toString();
        }
        return HttpHeaderValues.APPLICATION_JSON.toString();
    }
}

