/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.stargate;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.MsgBase;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.protocol.ProtocolEncoder;
import com.baidu.cloud.starlight.api.utils.GenericUtil;
import com.baidu.cloud.starlight.api.utils.NetUriUtils;
import com.baidu.cloud.starlight.protocol.stargate.StargateRequest;
import com.baidu.cloud.starlight.protocol.stargate.StargateResponse;
import com.baidu.cloud.starlight.serialization.serializer.DyuProtostuffSerializer;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBuf;
import com.baidu.cloud.thirdparty.netty.buffer.Unpooled;
import com.baidu.fengchao.stargate.remoting.exceptions.RpcBizException;
import com.baidu.fengchao.stargate.remoting.exceptions.RpcException;
import com.baidu.fengchao.stargate.remoting.exceptions.RpcExecutionException;
import com.baidu.fengchao.stargate.remoting.exceptions.RpcMethodNotFountException;
import com.baidu.fengchao.stargate.remoting.exceptions.RpcServiceNotFoundException;
import com.baidu.fengchao.stargate.remoting.exceptions.RpcSystemException;
import com.baidu.fengchao.stargate.remoting.exceptions.RpcTimeoutException;
import java.lang.reflect.Type;
import java.util.HashMap;

public class StargateEncoder
implements ProtocolEncoder {
    private static final int SERVICE_NOT_FOUND_EXCEPTION = 1001;
    private static final int METHOD_NOT_FOUND_EXCEPTION = 1002;
    private static final int BAD_REQUEST = 1003;
    private static final int TIME_OUT_EXCEPTION = 1008;
    private static final int BIZ_ERROR = 2002;

    @Override
    public ByteBuf encode(MsgBase input) throws CodecException {
        if (input == null) {
            throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "MsgBase is null, cannot use stargate to encode");
        }
        if (input instanceof Request) {
            Request request = (Request)input;
            return Unpooled.wrappedBuffer((byte[][])new byte[][]{this.stargateHeader(request.getBodyBytes().length), request.getBodyBytes()});
        }
        if (input instanceof Response) {
            Response response = (Response)input;
            return Unpooled.wrappedBuffer((byte[][])new byte[][]{this.stargateHeader(response.getBodyBytes().length), response.getBodyBytes()});
        }
        throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "MsgBase type is illegal {" + input.getClass().getName() + "}, cannot use stargate to encode");
    }

    @Override
    public void encodeBody(MsgBase msgBase) throws CodecException {
        if (msgBase == null) {
            throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "MsgBase is null, cannot use stargate to encode");
        }
        if (msgBase instanceof Request) {
            this.encodeRequestBody((Request)msgBase);
        }
        if (msgBase instanceof Response) {
            this.encodeResponseBody((Response)msgBase);
        }
    }

    private void encodeRequestBody(Request request) {
        if (request.getServiceConfig() == null) {
            throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "Cannot use stargate to encode, group / version is null");
        }
        URI uri = new URI.Builder("stargate", NetUriUtils.getLocalHost(), 0).param("group", request.getServiceConfig().getGroup()).param("version", request.getServiceConfig().getVersion()).param("interface", request.getServiceName()).param("generic", GenericUtil.isGenericCall(request)).build();
        StargateRequest stargateRequest = new StargateRequest(String.valueOf(request.getId()), uri, request.getMethodName(), request.getParamsTypes(), request.getParams());
        stargateRequest.setAttachments(new HashMap<String, Object>(request.getAttachmentKv()));
        byte[] bodyBytes = this.serializer().serialize(stargateRequest, (Type)((Object)StargateRequest.class));
        request.setBodyBytes(bodyBytes);
    }

    private void encodeResponseBody(Response response) {
        StargateResponse stargateResponse = new StargateResponse(String.valueOf(response.getId()));
        if (response.getRequest() != null && response.getRequest().getAttachmentKv() != null && response.getRequest().getAttachmentKv().get("stargate.id") != null) {
            stargateResponse.setId((String)response.getRequest().getAttachmentKv().get("stargate.id"));
        }
        stargateResponse.setResult(response.getResult());
        stargateResponse.setAttachments(response.getAttachmentKv());
        if (response.getStatus() != Constants.SUCCESS_CODE.intValue()) {
            stargateResponse.setException(this.generateStargateException(response));
        }
        byte[] bodyBytes = this.serializer().serialize(stargateResponse, (Type)((Object)StargateResponse.class));
        response.setBodyBytes(bodyBytes);
    }

    private DyuProtostuffSerializer serializer() {
        Protocol protocol = ExtensionLoader.getInstance(Protocol.class).getExtension("stargate");
        return (DyuProtostuffSerializer)protocol.getSerialize();
    }

    private byte[] stargateHeader(int bodyLength) {
        return new byte[]{(byte)(bodyLength >> 24 & 0xFF), (byte)(bodyLength >> 16 & 0xFF), (byte)(bodyLength >> 8 & 0xFF), (byte)(bodyLength & 0xFF)};
    }

    private RpcException generateStargateException(Response response) {
        switch (response.getStatus()) {
            case 1001: {
                return new RpcServiceNotFoundException(response.getErrorMsg());
            }
            case 1002: {
                return new RpcMethodNotFountException(response.getErrorMsg());
            }
            case 1003: {
                return new RpcExecutionException(response.getErrorMsg());
            }
            case 1008: {
                return new RpcTimeoutException(response.getErrorMsg());
            }
            case 2002: {
                return new RpcBizException(response.getErrorMsg());
            }
        }
        return new RpcSystemException(response.getErrorMsg());
    }
}

