/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.serialization.serializer;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.serialization.serializer.Serializer;
import com.baidu.cloud.starlight.serialization.utils.SerializationUtils;
import com.baidu.cloud.thirdparty.protostuff.LinkedBuffer;
import com.baidu.cloud.thirdparty.protostuff.ProtobufIOUtil;
import com.baidu.cloud.thirdparty.protostuff.Schema;
import com.baidu.cloud.thirdparty.protostuff.runtime.DefaultIdStrategy;
import com.baidu.cloud.thirdparty.protostuff.runtime.IdStrategy;
import com.baidu.cloud.thirdparty.protostuff.runtime.RuntimeSchema;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoStuffSerializer
implements Serializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtoStuffSerializer.class);
    private static final int DEFAULT_ALLOCATE_NUM = 512;
    private ThreadLocal<LinkedBuffer> buffer = new ThreadLocal<LinkedBuffer>(){

        @Override
        protected LinkedBuffer initialValue() {
            return LinkedBuffer.allocate((int)512);
        }
    };
    private final Map<ClassLoader, ConcurrentHashMap<Integer, IdStrategy>> idStrategyMap = new ConcurrentHashMap<ClassLoader, ConcurrentHashMap<Integer, IdStrategy>>();

    @Override
    public byte[] serialize(Object obj, Type type) throws CodecException {
        return this.serialize(obj, type, IdStrategy.DEFAULT_FLAGS);
    }

    public byte[] serialize(Object obj, Type type, Integer strategyFlag) throws CodecException {
        if (obj == null) {
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "The message used to protostuff-serialize is null");
        }
        if (!(type instanceof Class)) {
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "The type to protostuff-serialize is not Class");
        }
        Class clazz = (Class)type;
        if (!this.isSupported(clazz)) {
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "The type {" + type + "} used to protostuff-deserialize is illegal");
        }
        long starTime = System.currentTimeMillis();
        try {
            Schema schema = RuntimeSchema.getSchema((Class)clazz, (IdStrategy)this.getIdStrategy(strategyFlag));
            byte[] result = ProtobufIOUtil.toByteArray((Object)obj, (Schema)schema, (LinkedBuffer)this.buffer.get());
            LOGGER.debug("Serialize obj cost: {}", (Object)(System.currentTimeMillis() - starTime));
            byte[] byArray = result;
            return byArray;
        }
        catch (Throwable e) {
            CodecException exception = SerializationUtils.convertToCodecException(e, CodecException.SERIALIZE_EXCEPTION, "Protostuff serialize error");
            LOGGER.error("Serialize error, ", e);
            throw exception;
        }
        finally {
            this.buffer.get().clear();
        }
    }

    @Override
    public Object deserialize(byte[] bytes, Type type) throws CodecException {
        return this.deserialize(bytes, type, IdStrategy.DEFAULT_FLAGS);
    }

    public Object deserialize(byte[] bytes, Type type, Integer strategyFlag) throws CodecException {
        if (bytes == null || bytes.length == 0) {
            throw new CodecException(CodecException.DESERIALIZE_EXCEPTION, "The bytes used to protostuff deserializing are empty");
        }
        if (!(type instanceof Class)) {
            throw new CodecException(CodecException.DESERIALIZE_EXCEPTION, "The type to protostuff deserializing is not Class");
        }
        Class clazz = (Class)type;
        if (!this.isSupported(clazz)) {
            throw new CodecException(CodecException.DESERIALIZE_EXCEPTION, "The type used to protostuff deserializing are illegal");
        }
        long starTime = System.currentTimeMillis();
        try {
            Schema schema = RuntimeSchema.getSchema((Class)clazz, (IdStrategy)this.getIdStrategy(strategyFlag));
            Object content = schema.newMessage();
            ProtobufIOUtil.mergeFrom((byte[])bytes, (Object)content, (Schema)schema);
            LOGGER.debug("Deserialize obj cost: {}", (Object)(System.currentTimeMillis() - starTime));
            return content;
        }
        catch (Throwable e) {
            CodecException exception = SerializationUtils.convertToCodecException(e, CodecException.DESERIALIZE_EXCEPTION, "Protostuff Deserialize error");
            LOGGER.error("Deserialize error, ", e);
            throw exception;
        }
    }

    private boolean isSupported(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return !clazz.isPrimitive();
    }

    private IdStrategy getIdStrategy(Integer strategyFlag) {
        IdStrategy idStrategy;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Map strategies = this.idStrategyMap.get(classLoader);
        if (strategies == null) {
            this.idStrategyMap.putIfAbsent(classLoader, new ConcurrentHashMap());
            strategies = this.idStrategyMap.get(classLoader);
        }
        if ((idStrategy = (IdStrategy)strategies.get(strategyFlag)) == null) {
            strategies.putIfAbsent(strategyFlag, new DefaultIdStrategy(strategyFlag.intValue()));
            idStrategy = (IdStrategy)strategies.get(strategyFlag);
        }
        return idStrategy;
    }
}

