/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.serialization.serializer;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.serialization.serializer.Serializer;
import com.baidu.cloud.starlight.serialization.utils.SerializationUtils;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSerializer
implements Serializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufSerializer.class);

    @Override
    public byte[] serialize(Object inputObj, Type type) throws CodecException {
        if (inputObj == null) {
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "The message used to protobuf serializing is null");
        }
        if (inputObj.getClass() != type || !this.isSupported(inputObj.getClass())) {
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "The type used to protobuf serializing is illegal");
        }
        try {
            return ((Message)inputObj).toByteArray();
        }
        catch (Throwable e) {
            CodecException codecException = SerializationUtils.convertToCodecException(e, CodecException.SERIALIZE_EXCEPTION, "Protobuf serialize error");
            LOGGER.error("Protobuf deserialize error, ", (Throwable)codecException);
            throw codecException;
        }
    }

    @Override
    public Object deserialize(byte[] bytes, Type type) throws CodecException {
        if (bytes == null || bytes.length == 0) {
            throw new CodecException(CodecException.DESERIALIZE_EXCEPTION, "The bytes used to protobuf deserializing are empty");
        }
        if (!(type instanceof Class)) {
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "The type to protobuf deserializing is not Class");
        }
        Class clazz = (Class)type;
        if (!this.isSupported(clazz)) {
            throw new CodecException(CodecException.DESERIALIZE_EXCEPTION, "The type used to protobuf deserializing are illegal");
        }
        try {
            Method outputParseFromMethod = clazz.getMethod("parseFrom", byte[].class);
            return outputParseFromMethod.invoke((Object)type, new Object[]{bytes});
        }
        catch (Throwable e) {
            CodecException codecException = SerializationUtils.convertToCodecException(e, CodecException.DESERIALIZE_EXCEPTION, "Protobuf deserialize error");
            LOGGER.error("Protobuf deserialize error, ", (Throwable)codecException);
            throw codecException;
        }
    }

    private boolean isSupported(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return MessageLite.class.isAssignableFrom(clazz);
    }
}

