/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.transport.netty;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.MsgBase;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.rpc.LocalContext;
import com.baidu.cloud.starlight.api.transport.buffer.DynamicCompositeByteBuf;
import com.baidu.cloud.starlight.api.transport.channel.ChannelAttribute;
import com.baidu.cloud.starlight.api.transport.channel.ChannelSide;
import com.baidu.cloud.starlight.api.transport.channel.RpcChannel;
import com.baidu.cloud.starlight.api.utils.LogUtils;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBuf;
import com.baidu.cloud.thirdparty.netty.channel.ChannelHandlerContext;
import com.baidu.cloud.thirdparty.netty.channel.SimpleChannelInboundHandler;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecoderHandler.class);

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        ChannelAttribute attribute = (ChannelAttribute)ctx.channel().attr(RpcChannel.ATTRIBUTE_KEY).get();
        if (attribute == null) {
            throw new TransportException("Netty Channel don't have ChannelAttribute instance, Channel Illegal");
        }
        ClassLoader classLoader = (ClassLoader)LocalContext.getContext("thread.classloader").get(ctx.channel().id().asLongText());
        if (classLoader != null && attribute.getRpcChannel().side().equals((Object)ChannelSide.CLIENT)) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else if (attribute.getRpcChannel().side().equals((Object)ChannelSide.CLIENT)) {
            LOGGER.warn("Class Loader related to channel {} is null, plz check", (Object)ctx.channel().id().asLongText());
        }
        RpcChannel rpcChannel = attribute.getRpcChannel();
        String remoteAddress = "";
        try {
            if (rpcChannel.getRemoteAddress() != null) {
                remoteAddress = rpcChannel.getRemoteAddress().getAddress().getHostAddress() + ":" + rpcChannel.getRemoteAddress().getPort();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Get remote addr from channel failed, remote addr value will be null, cause by: {}", (Object)e.getMessage());
        }
        long receiveTime = System.currentTimeMillis();
        long msgSize = msg.readableBytes();
        LOGGER.debug("Receive msg from {}, size {}", (Object)remoteAddress, (Object)msgSize);
        if (msg != null && msg.readableBytes() > 0) {
            attribute.getDynamicByteBuf().addBuffer(msg.retain());
        }
        while (attribute.getDynamicByteBuf().readableBytes() > 0) {
            try {
                MsgBase msgBase = this.protocolDecode(attribute, attribute.getDynamicByteBuf());
                if (msgBase == null) continue;
                LogUtils.addLogTimeAttachment(msgBase, "receive_byte_msg_time", receiveTime);
                msgBase.getNoneAdditionKv().put("remote_address", remoteAddress);
                LogUtils.addLogTimeAttachment(msgBase, "before_decode_header_time", receiveTime);
                LogUtils.addLogTimeAttachment(msgBase, "decode_header_cost", System.currentTimeMillis() - receiveTime);
                if (msgBase.getAttachmentKv() == null) {
                    msgBase.setAttachmentKv(new HashMap<String, Object>());
                }
                try {
                    msgBase.getAttachmentKv().put("remoteHost", rpcChannel.getRemoteAddress().getAddress().getHostAddress());
                    msgBase.getAttachmentKv().put("remotePort", rpcChannel.getRemoteAddress().getPort());
                }
                catch (Exception e) {
                    LOGGER.debug("Get remote addr from channel failed, remote addr value will be null, cause by: {}", (Object)e.getMessage());
                }
                ctx.fireChannelRead((Object)msgBase);
            }
            catch (CodecException e) {
                if (e.getCode().equals(CodecException.PROTOCOL_DECODE_NOTENOUGHDATA_EXCEPTION) || e.getCode().equals(CodecException.PROTOCOL_INSUFFICIENT_DATA_EXCEPTION)) {
                    LOGGER.warn("Decode header with the byteBuf failed, will retry: side {}, remoteAddr {}, recvMsgTime {}, size {}, cause by {}.", new Object[]{rpcChannel.side(), remoteAddress, receiveTime, msgSize, e.getMessage()});
                    break;
                }
                LOGGER.warn("Decode header with the byteBuf failed: side {}, remoteAddr {}, recvMsgTime {}, size {}, the last exception is {}.", new Object[]{rpcChannel.side(), remoteAddress, receiveTime, msgSize, e.getMessage()});
                throw e;
            }
        }
    }

    private MsgBase protocolDecode(ChannelAttribute attribute, DynamicCompositeByteBuf byteBuf) throws CodecException {
        try {
            if (attribute.getChannelProtocol() != null && !attribute.getChannelProtocol().equals("unspecified")) {
                return this.knowProtocolDecode(attribute.getChannelProtocol(), byteBuf);
            }
        }
        catch (CodecException e) {
            if (e.getCode().equals(CodecException.PROTOCOL_DECODE_NOTMATCH_EXCEPTION)) {
                attribute.resetChannelProtocol("unspecified");
            }
            throw e;
        }
        if (attribute.getChannelProtocol() == null || attribute.getChannelProtocol().equals("unspecified")) {
            return this.unKnowProtocolDecode(attribute, byteBuf);
        }
        return null;
    }

    private MsgBase knowProtocolDecode(String protocolName, DynamicCompositeByteBuf byteBuf) throws CodecException {
        Protocol protocol = ExtensionLoader.getInstance(Protocol.class).getExtension(protocolName);
        return protocol.getDecoder().decode(byteBuf);
    }

    private MsgBase unKnowProtocolDecode(ChannelAttribute attribute, DynamicCompositeByteBuf byteBuf) throws CodecException {
        MsgBase msgObj = null;
        Set<String> protocols = ExtensionLoader.getInstance(Protocol.class).getSupportedExtensions();
        int protocolNum = 1;
        for (String protocolName : protocols) {
            try {
                msgObj = this.knowProtocolDecode(protocolName, byteBuf);
                if (msgObj == null) continue;
                attribute.resetChannelProtocol(protocolName);
                break;
            }
            catch (CodecException e) {
                if (e.getCode().equals(CodecException.PROTOCOL_DECODE_NOTMATCH_EXCEPTION)) {
                    if (protocolNum < protocols.size()) continue;
                    throw e;
                }
                attribute.resetChannelProtocol(protocolName);
                LOGGER.debug("Attempts to use multiple protocols to decode failed. The reason for the last failed attempt is: protocol {}, message {}", (Object)protocolName, (Object)e.getMessage());
                throw e;
            }
            finally {
                ++protocolNum;
            }
        }
        return msgObj;
    }
}

