/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.config.inner;

import com.baidu.disconf.client.common.model.InstanceFingerprint;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisClientComConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisClientComConfig.class);
    protected static final DisClientComConfig INSTANCE = new DisClientComConfig();
    private InstanceFingerprint instanceFingerprint;

    public static DisClientComConfig getInstance() {
        return INSTANCE;
    }

    private DisClientComConfig() {
        this.initInstanceFingerprint();
    }

    private void initInstanceFingerprint() {
        Properties properties = System.getProperties();
        int port = 0;
        String host = properties.getProperty("VCAP_APP_HOST");
        if (host == null) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                host = addr.getHostName();
            }
            catch (UnknownHostException e) {
                LOGGER.info("");
            }
        } else {
            try {
                port = Integer.parseInt(properties.getProperty("VCAP_APP_HOST"));
            }
            catch (Exception e) {
                LOGGER.info("");
            }
        }
        this.instanceFingerprint = new InstanceFingerprint(host, port, UUID.randomUUID().toString());
    }

    public String getInstanceFingerprint() {
        return this.instanceFingerprint.getHost() + "_" + String.valueOf(this.instanceFingerprint.getPort()) + "_" + this.instanceFingerprint.getUuid();
    }
}

